<?php

namespace App\Controllers\backend;


use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use App\Models\JadwalModel;
use CodeIgniter\Controller;


class Jadwal extends Controller
{

    protected $loginModel;
    protected $capesModel;
    protected $userModel;
    protected $jadwalModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
        $this->capesModel = new CapesModel();
        $this->userModel = new UserModel();
        $this->jadwalModel = new JadwalModel();
    }

    public function index()
    {

        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

        // dd($submenu);

        $data = [
            'title' => 'Jadwal PPDB KB',
            'user' => $cekuser
        ];

        return view('backend/jadwal', $data);
    }

    public function fetchjadwalsemua()
    {
        if ($this->request->isAJAX()) {
            if ($jadwal = $this->jadwalModel->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'jadwal' => $jadwal
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function fetchjadwaldivisi()
    {
        if ($this->request->isAJAX()) {
            $cekdivisi = $this->request->getVar('cekdivisi');
            if ($jadwal = $this->jadwalModel->where('divisi', $cekdivisi)->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'jadwal' => $jadwal
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function savejadwal()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'tanggal' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Tanggal tidak boleh kosong'
                    ]
                ],
                'keterangan' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'keterangan tidak boleh kosong'

                    ]
                ],

                'divisi' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Divisi harus dipilih'
                    ]
                ],
                'sort' => [
                    'rules' => 'required|numeric',
                    'errors' => [
                        'required' => 'Sort harus dipilih',
                        'numeric' => 'sort harus angka'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses

                $tanggal = $this->request->getVar('tanggal');
                $keterangan = $this->request->getVar('keterangan');
                $divisi = $this->request->getVar('divisi');
                $sort = $this->request->getVar('sort');

                $insert = [
                    'tanggal' => $tanggal,
                    'keterangan' => $keterangan,
                    'divisi' => $divisi,
                    'sort' => $sort,
                ];


                $this->jadwalModel->insert($insert);
                $data = [
                    'responce' => 'success',
                    'pesan' => 'Jadwal berhasil ditambah'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editmodal()
    {
        if ($this->request->isAJAX()) {
            $idjadwal = $this->request->getVar('idjadwal');
            if ($jadwal = $this->jadwalModel->where('id', $idjadwal)->get()->getRowArray()) {
                $data = [
                    'responce' => 'success',
                    'jadwal' => $jadwal
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal memunculkan modal edit data'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editjadwal()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'tanggal' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Tanggal tidak boleh kosong'
                    ]
                ],
                'keterangan' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'keterangan tidak boleh kosong'

                    ]
                ],

                'divisi' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Divisi harus dipilih'
                    ]
                ],
                'sort' => [
                    'rules' => 'required|numeric',
                    'errors' => [
                        'required' => 'Sort harus dipilih',
                        'numeric' => 'sort harus angka'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                $idjadwal = $this->request->getVar('idjadwal');
                $tanggal = $this->request->getVar('tanggal');
                $keterangan = $this->request->getVar('keterangan');
                $divisi = $this->request->getVar('divisi');
                $sort = $this->request->getVar('sort');

                $update = [
                    'tanggal' => $tanggal,
                    'keterangan' => $keterangan,
                    'divisi' => $divisi,
                    'sort' => $sort,
                ];


                $this->jadwalModel->update($idjadwal, $update);
                $data = [
                    'responce' => 'success',
                    'pesan' => 'Data berhasil diupdate'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function deletejadwal($id)
    {
        if ($this->request->isAJAX()) {
            $this->jadwalModel->where('id', $id)->delete();
            // $this->menuModel->where('id', $id)->delete();
        } else {
            echo "No direct script access allowed";
        }
    }
}
