<?php

namespace App\Controllers\backend;


use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use App\Models\TglbukaModel;
use App\Models\AlurModel;
use CodeIgniter\Controller;


class Setting extends Controller
{

    protected $loginModel;
    protected $capesModel;
    protected $userModel;
    protected $tglBukaModel;
    protected $alurModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
        $this->capesModel = new CapesModel();
        $this->userModel = new UserModel();
        $this->tglBukaModel = new TglbukaModel();
        $this->alurModel = new AlurModel();
    }

    public function tanggal()
    {

        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
        $tglbuka = $this->tglBukaModel->get()->getRowArray();
        // dd($submenu);

        $data = [
            'title' => 'Tanggal Buka PPDB',
            'user' => $cekuser,
            'tglbuka' => $tglbuka
        ];

        return view('backend/tanggal', $data);
    }

    public function edittanggal()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'tglbuka' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Tanggal tidak boleh kosong'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                $idtanggal = $this->request->getVar('idtanggal');
                $tglbuka = $this->request->getVar('tglbuka');


                $update = [
                    'tglbuka' => $tglbuka
                ];

                $this->tglBukaModel->update($idtanggal, $update);

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Tanggal berhasil diupdate',
                    'update' => $update
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function alur()
    {
        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

        // dd($submenu);

        $data = [
            'title' => 'Alur PPDB',
            'user' => $cekuser

        ];

        return view('backend/alur', $data);
    }

    public function fetchalur()
    {
        if ($this->request->isAJAX()) {
            if ($alur = $this->alurModel->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'alur' => $alur
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch alur'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function tambahalur()
    {
        if ($this->request->isAJAX()) {

            if (!$this->validate([
                'foto' => [
                    'rules' => 'max_size[foto,10240]|is_image[foto]|mime_in[foto,image/jpg,image/jpeg,image/png]',
                    'errors' => [

                        'max_size' => 'ukuran gambar terlalu besar. Max 10 mb ',
                        'is_image' => 'foto yang anda pilih bukan gambar',
                        'mime_in' => 'Gunakan file ekstensi jpg/jpeg/png'
                    ]
                ],
                'sort' => [
                    'rules' => 'required|numeric',
                    'errors' => [
                        'required' => 'Sort tidak boleh kosong',
                        'numeric' => 'sort harus berupa angka'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                $fileFoto = $this->request->getFile('foto');

                if ($this->request->getVar('aktif') == null) {
                    $active = 0;
                } else {
                    $active = 1;
                }

                //generate nama file random
                $namaFoto = $fileFoto->getRandomName();

                $insert = [
                    'alur' => $namaFoto,
                    'sort' => $this->request->getVar('sort'),
                    'aktif' => $active,
                ];

                if ($this->alurModel->insert($insert)) {
                    //pindahkan gambar
                    $fileFoto->move('asset/images/alur', $namaFoto);
                };

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Data Pegawai berhasil ditambah',
                ];
            }
            echo json_encode($data);
        } else {
            echo "No Direct Script access allowed";
        }
    }

    public function deletealur($id)
    {
        if ($this->request->isAJAX()) {

            if ($alur = $this->alurModel->where('id', $id)->get()->getRowArray()) {
                unlink('asset/images/alur/' . $alur['alur']);
            }

            $this->alurModel->where('id', $id)->delete();
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editalurmodal()
    {
        if ($this->request->isAJAX()) {
            $idalur = $this->request->getVar('idalur');
            if ($alur = $this->alurModel->where('id', $idalur)->get()->getRowArray()) {
                $data = [
                    'responce' => 'success',
                    'alur' => $alur
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal memunculkan modal edit data'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editalur()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'sort' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Sort tidak boleh kosong'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                $idalur = $this->request->getVar('idalur');
                $sort = $this->request->getVar('sort');

                if ($this->request->getVar('aktif') == null) {
                    $active = 0;
                } else {
                    $active = 1;
                }

                $update = [
                    'sort' => $sort,
                    'aktif' => $active
                ];

                $this->alurModel->update($idalur, $update);

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Alur berhasil diupdate',

                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }
}
