<?php

namespace App\Controllers\backend;


use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use App\Models\TglbukaModel;
use App\Models\AlurModel;
use App\Models\BiayaModel;
use App\Models\KelasModel;
use CodeIgniter\Controller;


class Kelas extends Controller
{

  protected $loginModel;
  protected $capesModel;
  protected $userModel;
  protected $tglBukaModel;
  protected $alurModel;
  protected $biayaModel;
  protected $kelasModel;


  public function __construct()
  {
    helper('fisi');
    $this->loginModel = new LoginModel();
    $this->capesModel = new CapesModel();
    $this->userModel = new UserModel();
    $this->tglBukaModel = new TglbukaModel();
    $this->alurModel = new AlurModel();
    $this->biayaModel = new BiayaModel();
    $this->kelasModel = new KelasModel();
  }

  public function index()
  {
    $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

    // dd($submenu);

    $data = [
      'title' => 'Kelas Tersedia',
      'user' => $cekuser

    ];

    return view('backend/kelas', $data);
  }

  public function fetchkelas()
  {
    if ($this->request->isAJAX()) {
      if ($kelas = $this->kelasModel->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'kelas' => $kelas
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch biaya'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function fetchkelasdivisi()
  {
    if ($this->request->isAJAX()) {
      $cekdivisi = $this->request->getVar('cekdivisi');
      if ($kelas = $this->kelasModel->where('divisi', $cekdivisi)->findAll()) {
        // dd($statuspegawai);
        $data = [
          'responce' => 'success',
          'kelas' => $kelas
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal fetch kelas'
        ];
      }

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editkelasmodal()
  {
    if ($this->request->isAJAX()) {
      $idkelas = $this->request->getVar('idkelas');
      if ($kelas = $this->kelasModel->where('id', $idkelas)->get()->getRowArray()) {
        $data = [
          'responce' => 'success',
          'kelas' => $kelas
        ];
      } else {
        $data = [
          'responce' => 'error',
          'pesan' => 'gagal memunculkan modal edit data'
        ];
      }
      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }

  public function editkelas()
  {
    if ($this->request->isAJAX()) {
      $idkelas = $this->request->getVar('idkelas');

      if ($this->request->getVar('aktif') == null) {
        $active = 0;
      } else {
        $active = 1;
      }

      $update = [
        'aktif' => $active
      ];

      $this->kelasModel->update($idkelas, $update);

      $data = [
        'responce' => 'success',
        'pesan' => 'Kelas berhasil diupdate',

      ];

      echo json_encode($data);
    } else {
      echo "No direct script access allowed";
    }
  }
}
