<?= $this->extend('template_front'); ?>

<?= $this->section('content'); ?>

<!-- ini buat spasi antara navbar dan greeting section -->
<div class="margin-bottom-100"></div>

<!-- Start Table-peserta -->
<section class="table-peserta margin-top-100 margin-bottom-100">

  <div class="container">



    <div class="row">
      <div class="col-md-12">

        <h2 style="text-align: center;">Data Peserta</h2>

        <hr>
        <!-- <button type="submit" id="btntambahcapes" class="btn btn-primary btn-lg btn-block">Daftar</button> -->
        <button type="button" class="btn btn-info btn-lg btn-block mb-3" data-toggle="modal" data-target="#cekstatusModal">
          Cek Status peserta
        </button>

        <!-- modal Cek Status -->
        <div class="modal fade" id="cekstatusModal" tabindex="-1" aria-labelledby="cekstatusModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-lg">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="cekstatusModalLabel">Cek Status Pendaftaran Peserta</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <!-- Form Tambah Data -->
                <form action="" method="POST">
                  <div class="form-group row">
                    <label for="nik" class="col-sm-3 col-form-label">Input NIK Peserta</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control" name="nik" id="nik">
                    </div>
                  </div>
                  <div class="form-group row">
                    <label for="cek" class="col-sm-3 col-form-label"></label>
                    <div class="col-sm-9">
                      <button type="button" id="cekstatus" class="btn btn-primary">Cek Status</button>
                    </div>
                  </div>

                  <div class="form-group-row">
                    <div class="col-sm-12" id="datapeserta">
                      <!-- Status Pendaftaran Peserta Didik dengan No.Reg <b>546321</b> dan bernama <b>nama lengkap</b> adalah: -->
                    </div>
                  </div>

                  <div class="form-group row">
                    <div class="col-sm-12" id="historistatus">
                      <!-- <button type="button" class="btn btn-primary">Cek Status</button> -->

                    </div>
                  </div>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <!-- <button type="submit" class="btn btn-primary" id="btnimportcapes">Import</button> -->
              </div>
              </form>
            </div>
          </div>
        </div>

      </div>

    </div>




    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped table-condensed" id="tabelCapes">
            <thead class="thead-dark">
              <tr>
                <th>NO</th>
                <th>Nama</th>
                <th>No Registrasi</th>
                <th>Kelas</th>
                <th>Divisi</th>
                <th>No.Pembayaran</th>
                <th>Status Pembayaran</th>

              </tr>
            </thead>

          </table>
        </div>
      </div>
    </div><br>
    <div class="row">
      <div class="col">
        <div class="alert alert-success" role="alert">
          <h5 class="alert-heading">INFORMASI PEMBAYARAN FORMULIR PENDAFTARAN</h5>
          <p>Mohon segera lakukan pembayaran ke <b>Bank Syariah Indonesia (BSI)</b> menggunakan nomor pembayaran sesuai dengan <b>No.Pembayaran calon peserta didik masing-masing</b> dengan nominal yang bisa dicek di <b>menu biaya</b> sesuai satuan pendidikan yang didaftar. Jangka waktu pembayaran <b>maksimal 3x24 jam</b> terhitung sejak nomor pembayaran diterbitkan. Proses update pembayaran, dilakukan pada <b>jam kerja senin - jum'at pukul 08.00-14.00 WIB</b></p>
          <p></p>
        </div>
      </div>
    </div>
  </div>

</section>
<!-- /End Table-peserta -->

<script>
  $(document).ready(function() {

    function tabelcapes(dataks) {
      let i = "1";
      $('#tabelCapes').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
          extend: 'pdfHtml5',
          text: '<i class="fas fa-fw fa-file-pdf"></i>',

          titleAttr: 'PDF'
        }],
        "columnDefs": [{
          "className": "text-center",
          "targets": "_all"
        }],

        "columns": [

          {
            "data": null,
            "render": function() {

              return a = i++;
            }
          },

          {
            "data": "nama_lengkap"
          },
          {
            "data": "no_reg",

            "render": function(data, type, row, meta) {

              let a = `<span class="badge badge-info">` + data + `</span>`;

              return a
            }
          },

          // {
          //     "data": "no_va"
          // },
          {
            "data": "kelas"
          },
          {
            "data": "divisi",
            "render": function(data, type, row, meta) {

              let a = data.toUpperCase();

              return a
            }
          },
          {
            "data": "no_va",
            "render": function(data, type, row, meta) {

              let a = '';
              a = `<span class="badge badge-primary">` + data + `</span>`
              return a
            }
          },
          {

            "data": 'status_pembayaran',

            "render": function(data, type, row, meta) {

              let a = '';
              if (data == 'belum') {
                a = `<span class="badge badge-danger">` + data + `</span>`
              } else {
                a = `<span class="badge badge-success">` + data + `</span>`
              }
              return a
            }
          },


        ]
      });
    }

    //fetch Capes semua
    function fetchCapesSemua() {
      $.ajax({
        url: '<?= base_url(); ?>/fetchcapesfront',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);

          tabelcapes(data.capes)
        }
      });
    }

    fetchCapesSemua();


    $('#cekstatus').on('click', function() {
      var nik = $("#nik").val();
      $.ajax({
        url: '<?= base_url('/capes/cekstatuscapes'); ?>',
        data: {
          nik: nik
        },
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#cekstatus').attr('disabled');
          $("#cekstatus").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            // console.log(data.responce);

            // A list item
            // <span class="badge badge-primary badge-pill"><i class="fas fa-check"></i></span>
            // <span class="badge badge-danger badge-pill"><i class="fas fa-times"></i></span>

            if (data.capes.no_va != "") {
              var tahap1 = `<span class="badge badge-primary badge-pill"><i class="fas fa-check"></i></span> Anda sudah mendapatkan nomor pembayaran dengan no.<span class="bg-primary badge-pill text-white">` + data.capes.no_va + `</span>. Silahkan melakukan pembayaran untuk melanjutkan tahap berikutnya`;
            } else {
              var tahap1 = `<span class="badge badge-danger badge-pill"><i class="fas fa-times"></i></span> Mohon bersabar untuk menunggu nomor pembayaran. Jika dalam waktu 1x24 jam di hari kerja tidak terupdate, silahkan hubungi kontak Humas MIJ di No. <a href="tel:08111264720"> 08111264720 (Hotline)</a>`;
            }



            if (data.capes.divisi == "ra") {
              var linkform = "https://docs.google.com/forms/d/e/1FAIpQLScCshcejQ3Wk56RuJgQhV6v_Xo-qfs1Z1CAWw-IbhpcBt-PBA/viewform";
              var satuanform = "RA";
            } else if (data.capes.divisi == "kb") {
              var linkform = "https://docs.google.com/forms/d/e/1FAIpQLSeD4VEF5tEGRGmsP9m3fAYnMrNTv_WG94hTi2wUk0eqFG3oMg/viewform";
              var satuanform = "KB";
            } else if (data.capes.divisi == "mi") {
              var linkform = "https://docs.google.com/forms/d/e/1FAIpQLScDdrR_RP-lfMg5VXxCobRmrijo33muaIOzW8ss9O8qmdGOUA/viewform";
              var satuanform = "MI";
            } else if (data.capes.divisi == "mts") {
              var linkform = "https://docs.google.com/forms/d/e/1FAIpQLSdkdlSHvK082CVoszT4HNC_9Uap1zRldg854EzumJ0ZK-Oe_Q/viewform";
              var satuanform = "MTs";
            } else if (data.capes.divisi == "ma") {
              var linkform = "https://docs.google.com/forms/d/e/1FAIpQLSfwPGu2dtipkNrzwzIKDEYZ9xIxtOxL5sclNSUjC4-BOSSjIQ/viewform";
              var satuanform = "MA";
            } else {
              var linkform = "https://www.google.com";
              var satuanform = "Tidak Ada";

            }

            if (data.capes.status_pembayaran == "sudah") {
              var tahap2 = `<span class="badge badge-primary badge-pill"><i class="fas fa-check"></i></span> Terima kasih Anda sudah melakukan pembayaran registrasi. Silahkan cek persyaratan upload di link <a href="https://docs.google.com/spreadsheets/d/1Hq57httfMNd_hbRJ17gxG_djidXVZG1tHP2eBJMTxFE/edit?usp=sharing'); ?>" target="_blank">persyaratan dokumen</a> sebelum  mengisi formulir berikutnya di link yang disediakan di bawah ini<br><br>
              
              
              <a href="` + linkform + `" class="btn btn-info btn-lg btn-block mb-3" target="_blank">Formulir Lanjutan Satuan Pendidikan ` + satuanform + `</a>

              
              `;
            } else {
              var tahap2 = `<span class="badge badge-danger badge-pill"><i class="fas fa-times"></i></span> Silahkan melakukan pembayaran registrasi setelah mendapatkan nomor pembayaran di tahap pertama `;
            }


            $("#datapeserta").html(`Status Pendaftaran Peserta Didik dengan No.Reg <b> ` + data.capes.no_reg + ` </b> dan bernama <b>` + data.capes.nama_lengkap + `</b> adalah:`);

            $("#historistatus").html(`
              <ul class="list-group">
                <li class="list-group-item" id="tahap1">
                   ` + tahap1 + `
                </li>
                <li class="list-group-item" id="tahap2">
                   ` + tahap2 + `
                </li>
              </ul>
              
              `);



          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#cekstatus').removeAttr('disabled');
          $("#cekstatus").html(`Cek Status`);

        },
      });
    });




  });
</script>

<?= $this->endSection(); ?>