<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>



<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">


    <div class="row">

      <div class="col-md-12">


        <div class="row mb-2">


          <div class="col-md-4">
            <form action="">
              <div class="form-group row">
                <label for="cekva" class="col-sm-6 col-form-label">Cek Status Pembayaran</label>
                <div class="col-sm-6">
                  <select name="cekva" id="cekva" class="form-control">
                    <option value="semua" selected>Tampilkan semua</option>
                    <option value="sudah">Sudah pembayaran </option>
                    <option value="belum">Belum pembayaran</option>
                  </select>
                </div>
              </div>
            </form>
          </div>

          <div class="col-md-4">
            <div class="form-group row">
              <!-- <label for="bulan" class="col-sm-2 col-form-label">Divisi</label>
              <div class="col-sm-4">

                <select id="searchdivisi" name="searchdivisi" class="form-control">
                  <option id="selectdivisisemua" selected value="semua">Semua</option>
                  <option value="kb">KB</option>
                  <option value="ra">RA</option>
                  <option value="mi">MI</option>
                  <option value="mts">MTs</option>
                  <option value="ma">MA</option>

                </select>
              </div> -->

              <label for="searchdivisi" class="col-sm-2 col-form-label">Divisi</label>
              <div class="col-sm-4">
                <input type="text" class="form-control" id="searchdivisi" name="searchdivisi">
              </div>
            </div>


          </div>

          <div class="col-md-4">

            <button type="button" class="btn btn-danger" name="btndeletecapes" id="btndeletecapes">
              Hapus
            </button>

            <!-- <button type="button" class="btn btn-info" data-toggle="modal" data-target="#importModal">
              Import
            </button> -->
            <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#updatevaModal">
              Update No VA
            </button>
            <button type="button" class="btn btn-info" data-toggle="modal" data-target="#updatstatusModal">
              Update Status
            </button>
          </div>



          <!-- Modal Edit -->
          <div class="modal fade" id="editCapesModal" tabindex="-1" aria-labelledby="editCapesModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-xl">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="editCapesModalLabel">Edit Calon Peserta Didik</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <form method="post" action="" id="editcapesform">
                    <?= csrf_field(); ?>
                    <input type="hidden" name="idcapes">
                    <input type="hidden" name="niklama">
                    <input type="hidden" name="no_va_lama">
                    <input type="hidden" name="status_pembayaran_lama">

                    <div class="form-group row">
                      <label for="no_reg" class="col-sm-3 col-form-label">No.Reg</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="no_reg" readonly>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="nik" class="col-sm-3 col-form-label">NIK</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="nik" readonly>
                      </div>
                    </div>




                    <div class="form-group row">
                      <label for="nama_lengkap" class="col-sm-3 col-form-label">Nama</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="nama_lengkap">
                      </div>
                    </div>

                    <div class="form-group row">
                      <label for="nama_ortu" class="col-sm-3 col-form-label">Nama Orang Tua</label>
                      <div class="col-sm-9">
                        <input type="text" class="form-control" name="nama_ortu">
                      </div>
                    </div>


                    <div class="form-group row">

                      <label for="tgllahir" class="col-sm-3 col-form-label">Tgl Lahir</label>
                      <div class="col-sm-3">
                        <input type="date" class="form-control" id="tgllahir" name="tgllahir">

                      </div>
                      <label for="usia" class="col-sm-2 col-form-label">Usia</label>
                      <div class="col-sm-4">
                        <input type="text" class="form-control" name="usia" id="usia" value="" placeholder="Umur dihitung tanggal 1 Juli 2022" readonly>
                      </div>
                    </div>

                    <div class="form-group row">
                      <label for="sekolahasal" class="col-sm-3 col-form-label">Sekolah Asal</label>
                      <div class="col-sm-3">
                        <input type="text" class="form-control" name="sekolahasal" id="sekolahasal" placeholder="masukkan Nama Sekolah Asal">
                      </div>
                      <label for="j_kel" class="col-sm-2 col-form-label">Jenis Kelamin</label>
                      <div class="col-sm-4">
                        <select name="j_kel" id="editj_kel" class="form-control">
                          <option value="" selected disabled>Pilih jenis kelamin</option>
                          <option value="laki-laki">laki-laki</option>
                          <option value="perempuan">perempuan</option>

                        </select>
                      </div>

                    </div>


                    <div class="form-group row">
                      <label for="nohp" class="col-sm-3 col-form-label">Nomor HP</label>
                      <div class="col-sm-3">
                        <input type="text" class="form-control" name="nohp" id="nohp" placeholder="masukkan No HP">
                      </div>
                      <label for="email" class="col-sm-2 col-form-label">Email</label>
                      <div class="col-sm-4">
                        <input type="email" class="form-control" name="email">
                      </div>
                    </div>

                    <div class="form-group row">
                      <label for="saudaramij" class="col-sm-3 col-form-label">Jumlah Saudara <b>KANDUNG</b> yang <b>AKTIF</b> bersekolah di MIJ?</label>
                      <div class="col-sm-3">
                        <!-- <input type="text" class="form-control" name="saudarakandung" id="saudarakandung" placeholder="masukkan No HP"> -->
                        <select name="saudarakandung" id="saudarakandung" class="form-control">
                          <option value="" selected disabled>Punya Saudara?</option>
                          <option value="tidak">tidak</option>
                          <option value="punya">punya</option>

                        </select>
                      </div>
                      <label for="anakke" class="col-sm-2 col-form-label">Anak ke</label>
                      <div class="col-sm-1">
                        <input type="text" class="form-control" name="anakke" id="anakke" placeholder="Anak Ke-">
                      </div>
                      <label for="jumlahsaudara" class="col-sm-1 col-form-label">Dari</label>
                      <div class="col-sm-1">
                        <input type="text" class="form-control" name="jumlahsaudara" id="jumlahsaudara" placeholder="Jumlah anak">
                      </div>
                      <label for="jumlahsaudara" class="col-sm-1 col-form-label">Bersaudara</label>
                    </div>


                    <div class="form-group row">
                      <label for="divisi" class="col-sm-3 col-form-label">Divisi</label>
                      <div class="col-sm-3">

                        <input type="text" class="form-control" name="divisi" readonly>
                      </div>
                      <label for="kelas" class="col-sm-2 col-form-label">Kelas</label>
                      <div class="col-sm-4">
                        <input type="text" class="form-control" name="kelas" readonly>
                      </div>
                    </div>
                    <div class="form-group row">
                      <label for="catatan" class="col-sm-3 col-form-label">Kirim Email</label>
                      <div class="col-sm-9">
                        <!-- <p>Kedua Poin di bawah tidak akan mengirimkan email otomatis ke calon peserta didik</p> -->

                        <div class="form-check form-check-inline">
                          <input class="form-check-input" type="radio" name="kirimemailoption" id="tidakemail" value="tidak">
                          <label class="form-check-label" for="tidakemail">tidak</label>
                        </div>
                        <div class="form-check form-check-inline">
                          <input class="form-check-input" type="radio" name="kirimemailoption" id="emailva" value="emailva">
                          <label class="form-check-label" for="emailva">email update VA</label>
                        </div>
                        <div class="form-check form-check-inline">
                          <input class="form-check-input" type="radio" name="kirimemailoption" id="emailstatus" value="emailstatus">
                          <label class="form-check-label" for="emailstatus">Email Status Pembayaran</label>
                        </div>
                      </div>
                    </div>



                    <div class="form-group row">
                      <label for="no_va" class="col-sm-3 col-form-label">No.Pembayaran</label>
                      <div class="col-sm-3">
                        <input type="text" class="form-control" name="no_va">
                      </div>
                      <label for="status_pembayaran" class="col-sm-2 col-form-label">Status</label>
                      <div class="col-sm-4">
                        <select name="status_pembayaran" id="editstatus_pembayaran" class="form-control">

                        </select>
                      </div>
                    </div>



                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary" id="btneditcapes">Update</button>
                </div>
                </form>
              </div>
            </div>
          </div>

          <!-- modal import capes -->
          <div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="importModalLabel">Import Data Calon Peserta Didik</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <!-- Form Tambah Data -->
                  <form action="" method="POST" id="importcapes" enctype="multipart/form-data">
                    <div class="form_group" style="margin-bottom: 5;">
                      <label for="">Unggah File</label>
                      <input type="file" id="filecapes" name="filecapes" class="form-control">
                    </div>
                    <br>
                    <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_capes.xls">Download Template Import Calon Peserta Didik</a></p>

                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary" id="btnimportcapes">Import</button>
                </div>
                </form>
              </div>
            </div>
          </div>

          <!-- modal import update VA -->
          <div class="modal fade" id="updatevaModal" tabindex="-1" aria-labelledby="updatevaModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="updatevaModalLabel">Import VA Calon Peserta Didik</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <!-- Form Tambah Data -->
                  <form action="" method="POST" id="importva" enctype="multipart/form-data">
                    <div class="form_group" style="margin-bottom: 5;">
                      <label for="">Unggah File</label>
                      <input type="file" id="fileva" name="fileva" class="form-control">
                    </div>
                    <br>
                    <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_nova.xls">Download Template Import VA Calon Peserta Didik</a><br>Primary Key No.Registrasi</p>

                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary" id="btnupdatecapes">Update</button>
                </div>
                </form>
              </div>
            </div>
          </div>

          <!-- modal import update Status -->
          <div class="modal fade" id="updatstatusModal" tabindex="-1" aria-labelledby="updatestatusModalLabel" aria-hidden="true">
            <div class="modal-dialog">
              <div class="modal-content">
                <div class="modal-header">
                  <h5 class="modal-title" id="updatestatusModalLabel">Import Status Pembayaran Calon Peserta Didik</h5>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
                <div class="modal-body">
                  <!-- Form Tambah Data -->
                  <form action="" method="POST" id="importstatus" enctype="multipart/form-data">
                    <div class="form_group" style="margin-bottom: 5;">
                      <label for="">Unggah File</label>
                      <input type="file" id="filestatus" name="filestatus" class="form-control">
                    </div>
                    <br>
                    <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_status.xls">Download Template Import Status Pembayaran</a><br>Primary Key No.Pembayaran</p>

                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                  <button type="submit" class="btn btn-primary" id="btnupdatestatus">Update</button>
                </div>
                </form>
              </div>
            </div>
          </div>

        </div>

        <div class="row">
          <div class="col">
            <div class="table-responsive">
              <table class="table table-striped table-condensed" id="tabelCapes">
                <thead class="bg-success">
                  <tr>
                    <th><input type="checkbox" id='checkall'></th>
                    <!-- <th scope="col">No</th> -->
                    <th scope="col">Action</th>
                    <th scope="col">Tgl Daftar</th>
                    <th scope="col">No. Pembayaran</th>
                    <th scope="col">No Registrasi</th>
                    <th scope="col">NIK</th>
                    <th scope="col">Nama Lengkap</th>
                    <th scope="col">Nama Orang Tua</th>
                    <th scope="col">Tgl Lahir</th>
                    <th scope="col">Usia</th>
                    <th scope="col">Sekolah Asal</th>
                    <th scope="col">Jenis Kelamin</th>
                    <th scope="col">No.HP</th>
                    <th scope="col">Email</th>
                    <th scope="col">Punya Saudara di MIJ</th>
                    <th scope="col">Anak Ke</th>
                    <th scope="col">Jumlah Bersaudara</th>
                    <th scope="col">Kelas</th>
                    <th scope="col">Divisi</th>
                    <th scope="col">Info PPDB</th>
                    <th scope="col">Status Pembayaran</th>

                  </tr>
                </thead>

              </table>
            </div>
          </div>
        </div>

        <div class="overlay asal-divisi-overlay" style="display: none;">
          <!-- <i class="fas fa-sync fa-spin"></i> -->
          <div id='loading-img'></div>
        </div>



      </div>
    </div>



  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
  $(document).ready(function() {

    function tabelcapes(dataks) {
      $('#tabelCapes').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-7'l><'col-sm-12 col-md-4'f><'col-sm-12 col-md-1'B>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
            extend: 'excelHtml5',
            text: '<i class="far fa-fw fa-file-excel"></i>',
            titleAttr: 'Excel',
            customizeData: function(data) {
              for (var i = 0; i < data.body.length; i++) {
                for (var j = 0; j < data.body[i].length; j++) {
                  if (data.header[j] == "NIK") {
                    data.body[i][j] = '\0' + data.body[i][j];
                  }

                  if (data.header[j] == "NISN") {
                    data.body[i][j] = '\0' + data.body[i][j];
                  }

                  if (data.header[j] == "No Registrasi") {
                    data.body[i][j] = '\0' + data.body[i][j];
                  }

                  if (data.header[j] == "No. Pembayaran") {
                    data.body[i][j] = '\0' + data.body[i][j];
                  }
                }
              }
            }
          },
          {
            extend: 'csvHtml5',
            text: '<i class="fas fa-fw fa-file-csv"></i>',
            titleAttr: 'Csv',

          }
        ],

        "columnDefs": [{
          "className": "text-center",
          "targets": "_all"
        }],


        "columns": [

          {
            targets: 0,
            data: null,
            className: 'text-center',
            searchable: false,
            orderable: false,

            "render": function(data, type, row, meta) {
              var r =
                '<input type="checkbox" name="checkbox" id = "' + row.id + '"  value = "' + row.id + '" class="select_checkbox"></input>';

              return r;
            },
          },
          {
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              a = `
                                    <a href="" value="${row.id}" class="badge badge-info editcapes"><i class="fas fa-fw fa-edit"></i></a>`

              return a;
            }
          },

          {
            "data": "created_at"
          },
          {
            "data": "no_va"
          },
          {
            "data": "no_reg"
          },
          {
            "data": "nik",
            "render": function(data, type, row, meta) {


              let a = data.trim();

              return a
            }
          },

          {
            "data": "nama_lengkap"
          },
          {
            "data": "nama_ortu"
          },
          {
            "data": "tgl_lahir"
          },
          {
            "data": "usia"
          },
          {
            "data": "sekolah_asal"
          },
          {
            "data": "j_kel"
          },
          {
            "data": "no_hp"
          },
          {
            "data": "email"
          },
          {
            "data": "saudara_kandung"
          },
          {
            "data": "anak_ke"
          },
          {
            "data": "jumlah_saudara"
          },
          {
            "data": "kelas"
          },
          {
            "data": "divisi"
          },
          {
            "data": "infoppdb"
          },

          {

            "data": 'status_pembayaran',

            "render": function(data, type, row, meta) {


              let a = '';
              if (data == 'belum') {
                a = `<span class="badge badge-danger">` + data + `</span>`
              } else {
                a = `<span class="badge badge-success">` + data + `</span>`
              }
              return a
            }
          }

        ]
      });
    }




    //fetch capes VA belum
    function fetchCapesBelum() {
      $('.asal-divisi-overlay').show();
      $.ajax({
        url: '<?= base_url(); ?>/capes/fetchcapesbelum',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data.pegawai);

          $('#tabelCapes').DataTable().clear();
          $('#tabelCapes').DataTable().destroy();
          tabelcapes(data.capes)
        }
      });
      $('.asal-divisi-overlay').hide();
    }

    //fetch capes VA sudah
    function fetchCapesSudah() {
      $('.asal-divisi-overlay').show();
      $.ajax({
        url: '<?= base_url(); ?>/capes/fetchcapessudah',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data.pegawai);
          $('#tabelCapes').DataTable().clear();
          $('#tabelCapes').DataTable().destroy();
          tabelcapes(data.capes)
        }
      });
      $('.asal-divisi-overlay').hide();
    }

    //fetch Capes semua
    function fetchCapesSemua() {
      $('.asal-divisi-overlay').show();
      $.ajax({
        url: '<?= base_url(); ?>/capes/fetchcapessemua',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data.pegawai);
          $('#tabelCapes').DataTable().destroy();
          tabelcapes(data.capes)
        }
      });
      $('.asal-divisi-overlay').hide();
    }

    fetchCapesSemua();
    // fetchCapesSudah();

    $("#cekva").change(function() {
      let cekva = $("#cekva").val();
      // alert(divisiasal)
      if (cekva == 'semua') {
        fetchCapesSemua();
      } else if (cekva == 'belum') {
        fetchCapesBelum();
      } else {
        fetchCapesSudah();
      }
    })


    $('#searchdivisi').on('keyup', function() {
      $('#tabelCapes').DataTable()
        .columns(18)
        .search(this.value)
        .draw();
    });

    function getAge(dateString) {
      // var today = new Date();
      var today = new Date('July 1 2022 00:00');
      var birthDate = new Date(dateString);
      var age = today.getFullYear() - birthDate.getFullYear();
      var m = today.getMonth() - birthDate.getMonth();
      if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age--;
      }
      return age;
    }

    $("#tgllahir").change(function() {
      event.preventDefault();
      let cekusia = $("#tgllahir").val();
      let umur = getAge(cekusia)
      console.log(umur);
      $('#usia').val(umur);
    });


    // modal edit
    $(document).on("click", ".editcapes", function() {
      event.preventDefault();
      $("#editstatus_pembayaran").children().remove();
      // $("#editdivisi").children().remove();
      $("#editj_kel").children().remove();
      $("#saudarakandung").children().remove();
      let idcapes = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/capes/editmodal'); ?>',
        type: 'post',
        data: {
          idcapes: idcapes
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            $('#editCapesModal').modal('show');
            $("input[name='idcapes']").val(data.capes.id);
            $("input[name='no_reg']").val(data.capes.no_reg);
            $("input[name='nik']").val(data.capes.nik);
            $("input[name='niklama']").val(data.capes.nik);

            $("input[name='nama_lengkap']").val(data.capes.nama_lengkap);
            $("input[name='nama_ortu']").val(data.capes.nama_ortu);
            $("input[name='tgllahir']").val(data.capes.tgl_lahir);
            $("input[name='usia']").val(data.capes.usia);
            $("input[name='sekolahasal']").val(data.capes.sekolah_asal);
            $("input[name='nohp']").val(data.capes.no_hp);
            $("input[name='email']").val(data.capes.email);
            $("input[name='anakke']").val(data.capes.anak_ke);
            $("input[name='jumlahsaudara']").val(data.capes.jumlah_saudara);

            $("#tidakemail").prop("checked", true);

            $("input[name='kelas']").val(data.capes.kelas);
            $("input[name='no_va']").val(data.capes.no_va);
            $("input[name='divisi']").val(data.capes.divisi.toUpperCase());
            $("input[name='status_pembayaran_lama']").val(data.capes.status_pembayaran);

            // $("#editdivisi").append('<option disabled selected>Tampilkan semua</option>');
            // $("#editdivisi").append('<option value="kb"' + ((data.capes.divisi == 'kb') ? 'selected="selected"' : '') + '>KB</option>');
            // $("#editdivisi").append('<option value="ra"' + ((data.capes.divisi == 'ra') ? 'selected="selected"' : '') + '>RA</option>');
            // $("#editdivisi").append('<option value="mi"' + ((data.capes.divisi == 'mi') ? 'selected="selected"' : '') + '>MI</option>');
            // $("#editdivisi").append('<option value="mts"' + ((data.capes.divisi == 'mts') ? 'selected="selected"' : '') + '>MTS</option>');
            // $("#editdivisi").append('<option value="ma"' + ((data.capes.divisi == 'ma') ? 'selected="selected"' : '') + '>MA</option>');


            $("input[name='no_va']").val(data.capes.no_va);
            $("input[name='no_va_lama']").val(data.capes.no_va);

            $("#editj_kel").append('<option disabled selected>Pilih Jenis Kelamin</option>');
            $("#editj_kel").append('<option value="laki-laki"' + ((data.capes.j_kel == 'laki-laki') ? 'selected="selected"' : '') + '>Laki-Laki</option>');
            $("#editj_kel").append('<option value="perempuan"' + ((data.capes.j_kel == 'perempuan') ? 'selected="selected"' : '') + '>Perempuan</option>');

            $("#saudarakandung").append('<option disabled selected>Jumlah Saudara</option>');
            $("#saudarakandung").append('<option value="0"' + ((data.capes.saudara_kandung == '0') ? 'selected="selected"' : '') + '>0</option>');
            $("#saudarakandung").append('<option value="1"' + ((data.capes.saudara_kandung == '1') ? 'selected="selected"' : '') + '>1</option>');
            $("#saudarakandung").append('<option value="2"' + ((data.capes.saudara_kandung == '2') ? 'selected="selected"' : '') + '>2</option>');
            $("#saudarakandung").append('<option value="3"' + ((data.capes.saudara_kandung == '3') ? 'selected="selected"' : '') + '>3</option>');
            $("#saudarakandung").append('<option value="4"' + ((data.capes.saudara_kandung == '4') ? 'selected="selected"' : '') + '>4</option>');
            $("#saudarakandung").append('<option value="5"' + ((data.capes.saudara_kandung == '5') ? 'selected="selected"' : '') + '>5</option>');
            $("#saudarakandung").append('<option value="6"' + ((data.capes.saudara_kandung == '6') ? 'selected="selected"' : '') + '>6</option>');
            $("#saudarakandung").append('<option value="7"' + ((data.capes.saudara_kandung == '7') ? 'selected="selected"' : '') + '>7</option>');
            $("#saudarakandung").append('<option value="8"' + ((data.capes.saudara_kandung == '8') ? 'selected="selected"' : '') + '>8</option>');
            $("#saudarakandung").append('<option value="9"' + ((data.capes.saudara_kandung == '9') ? 'selected="selected"' : '') + '>9</option>');
            $("#saudarakandung").append('<option value="10"' + ((data.capes.saudara_kandung == '10') ? 'selected="selected"' : '') + '>10</option>');


            $("#editstatus_pembayaran").append('<option disabled selected>Tampilkan semua</option>');
            $("#editstatus_pembayaran").append('<option value="belum"' + ((data.capes.status_pembayaran == 'belum') ? 'selected="selected"' : '') + '>belum</option>');
            $("#editstatus_pembayaran").append('<option value="sudah"' + ((data.capes.status_pembayaran == 'sudah') ? 'selected="selected"' : '') + '>sudah</option>');

          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    // edit capes

    $("#editcapesform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/capes/editcapes',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btneditcapes').attr('disabled');
          $("#btneditcapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);
        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editCapesModal').modal('hide');
            $('#tabelCapes').DataTable().destroy();
            fetchCapesSemua();
            // $('#tambahcapesform')[0].reset();
            console.log(data.pesanemail)
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }

        },
        complete: function() {
          $('#btneditcapes').removeAttr('disabled');
          $("#btneditcapes").html(`Update`);
        },
      });
    })

    // import calon peserta
    $('#importcapes').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/capes/importcapes'); ?>',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnimportcapes').attr('disabled');
          $("#btnimportcapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#tabelCapes').DataTable().destroy();
            fetchCapesSemua();
            $('#importModal').modal('hide');
            toastr["success"](data.pesan);
          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnimportcapes').removeAttr('disabled');
          $("#btnimportcapes").html(`Import`);
          $('#importcapes')[0].reset();
        },
      });

    });

    // import VA
    $('#importva').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/capes/importva'); ?>',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnupdatecapes').attr('disabled');
          $("#btnupdatecapes").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#tabelCapes').DataTable().destroy();
            fetchCapesSemua();
            $('#updatevaModal').modal('hide');
            console.log(data.pesanemail)
            toastr["success"](data.pesan);
          } else {
            // console.log(data);

            $('#updatevaModal').modal('hide');
            Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: 'No.Reg tidak ada di database pada baris ' + data.barisgagal
            })
          }
        },
        complete: function() {
          $('#btnupdatecapes').removeAttr('disabled');
          $("#btnupdatecapes").html(`Update`);

          $('#importva')[0].reset();
        },
      });

    });

    // import status pembayaran
    $('#importstatus').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/capes/importstatus'); ?>',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnupdatestatus').attr('disabled');
          $("#btnupdatestatus").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#updatstatusModal').modal('hide');
            $('#tabelCapes').DataTable().destroy();
            fetchCapesSemua();
            console.log(data.pesanemail)
            toastr["success"](data.pesan);
          } else {
            // console.log(data);

            $('#updatstatusModal').modal('hide');
            Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: 'No.Pembayaran tidak ada di database pada baris ' + data.barisgagal
            })
          }
        },
        complete: function() {
          $('#btnupdatestatus').removeAttr('disabled');
          $("#btnupdatestatus").html(`Update`);

          $('#importva')[0].reset();
        },
      });

    });

    // Check all 
    $('#checkall').click(function() {
      if ($(this).is(':checked')) {
        $('.select_checkbox').prop('checked', true);
      } else {
        $('.select_checkbox').prop('checked', false);
      }
    });

    $('.select_checkbox').click(function() {
      if ($(this).is(':checked')) {
        $(this).closest('tr').addClass('removeRow');
      } else {
        $(this).closest('tr').removeClass('removeRow');
      }
    });

    // button delete
    $('#btndeletecapes').click(function() {
      let checkbox = $('.select_checkbox:checked');

      if (checkbox.length > 0) {
        Swal.fire({
          title: 'Apa kamu yakin ingin menghapus ' + checkbox.length + ' calon peserta didik?',
          text: "kamu tidak akan bisa mengembalikannya!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, hapus saja!'
        }).then((result) => {
          if (result.isConfirmed) {

            let checkbox_value = [];
            $(checkbox).each(function() {
              checkbox_value.push($(this).val());
            });

            // console.log(checkbox);
            $.ajax({
              url: '<?= base_url('/capes/deletecapes'); ?>',
              type: "POST",
              data: {
                checkbox_value: checkbox_value
              },
              dataType: 'json',
              success: function(data) {
                if (data.responce == "success") {
                  Swal.fire(
                    'Deleted!',
                    'Data berhasil dihapus.',
                    'success'
                  )
                  $('#tabelCapes').DataTable().destroy();
                  fetchCapesSemua();
                } else {
                  Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Ada yang tidak beres!',
                  })
                }
              }
            })

          }
        })

      } else {
        Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: 'Pilih minimal satu data',
        })

      }
    });






  })
</script>

<?= $this->endSection(); ?>