<?php

namespace App\Controllers\backend;


use App\Models\LoginModel;
use App\Models\CapesModel;
use App\Models\UserModel;
use CodeIgniter\Controller;


class ProfilUser extends Controller
{

    protected $loginModel;
    protected $capesModel;
    protected $userModel;


    public function __construct()
    {
        $this->loginModel = new LoginModel();
        $this->capesModel = new CapesModel();
        $this->userModel = new UserModel();
    }

    public function index()
    {

        $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();

        // dd($submenu);

        $data = [
            'title' => 'Profil',
            'user' => $cekuser
        ];

        return view('backend/profiluser', $data);
    }

    public function fetchuser()
    {
        if ($this->request->isAJAX()) {
            if ($user = $this->userModel->findAll()) {
                // dd($statuspegawai);
                $data = [
                    'responce' => 'success',
                    'user' => $user
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal fetch jabatan'
                ];
            }

            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }



    public function saveuser()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'username' => [
                    'rules' => 'required|is_unique[user.username]',
                    'errors' => [
                        'required' => 'Username tidak boleh kosong',
                        'is_unique' => 'Username sudah ada'
                    ]
                ],
                'password' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'password tidak boleh kosong'

                    ]
                ],
                'repassword' => [
                    'rules' => 'required|matches[password]',
                    'errors' => [
                        'required' => 'repassword tidak boleh kosong',
                        'matches' => 're-password tidak sesuai'
                    ]
                ],
                'nama' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Nama tidak boleh kosong'
                    ]
                ],
                'level' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Level harus dipilih'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();

                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses

                $username = $this->request->getVar('username');
                $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
                $nama = $this->request->getVar('nama');
                $level = $this->request->getVar('level');

                $insert = [
                    'username' => $username,
                    'password' => $password,
                    'nama' => $nama,
                    'level' => $level,
                ];


                $this->userModel->insert($insert);
                $data = [
                    'responce' => 'success',
                    'pesan' => 'User berhasil ditambah'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editmodal()
    {
        if ($this->request->isAJAX()) {
            $iduser = $this->request->getVar('iduser');
            if ($user = $this->userModel->where('id', $iduser)->get()->getRowArray()) {
                $data = [
                    'responce' => 'success',
                    'user' => $user
                ];
            } else {
                $data = [
                    'responce' => 'error',
                    'pesan' => 'gagal memunculkan modal edit data'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function edituser()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'username' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Username tidak boleh kosong'
                    ]
                ],
                'nama' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Nama tidak boleh kosong'
                    ]
                ],
                'level' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'Level harus dipilih'
                    ]
                ]
            ])) {
                $validation = \Config\Services::validation();
                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
                $iduser = $this->request->getVar('iduser');
                $update = [
                    'username' => $this->request->getVar('username'),
                    'nama' => $this->request->getVar('nama'),
                    'level' => $this->request->getVar('level')
                ];


                $this->userModel->update($iduser, $update);

                $data = [
                    'responce' => 'success',
                    'pesan' => 'User berhasil diupdate'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }

    public function editpassword()
    {
        if ($this->request->isAJAX()) {
            if (!$this->validate([
                'password' => [
                    'rules' => 'required',
                    'errors' => [
                        'required' => 'password tidak boleh kosong'

                    ]
                ],
                'repassword' => [
                    'rules' => 'required|matches[password]',
                    'errors' => [
                        'required' => 'repassword tidak boleh kosong',
                        'matches' => 're-password tidak sesuai'
                    ]
                ],
            ])) {
                $validation = \Config\Services::validation();
                $data = [
                    'responce' => 'error',
                    'pesan' => $validation->listErrors()
                ];
            } else {
                // validasi sukses
                // $cekuser = $this->loginModel->where('id', session('id'))->get()->getRowArray();
                $iduser = $this->request->getVar('iduser');
                $password = password_hash($this->request->getVar('password'), PASSWORD_DEFAULT);
                $update = [
                    'password' => $password,
                ];


                $this->userModel->update($iduser, $update);

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Password berhasil diupdate'
                ];
            }
            echo json_encode($data);
        } else {
            echo "No direct script access allowed";
        }
    }


    public function deletecapes()
    {
        if ($this->request->isAJAX()) {
            if ($id = $this->request->getVar('checkbox_value')) {
                for ($count = 0; $count < count($id); $count++) {
                    // $this->karyawanModel->delete_karyawan($id[$count]);
                    $this->capesModel->where('id', $id[$count])->delete();
                }

                $data = [
                    'responce' => 'success',
                    'pesan' => 'Data calon peserta didik berhasil dihapus'
                ];

                echo json_encode($data);
            }
        } else {
            echo "No direct script access allowed";
        }
    }

    public function deleteuser($id)
    {
        if ($this->request->isAJAX()) {
            $this->userModel->where('id', $id)->delete();
        } else {
            echo "No direct script access allowed";
        }
    }
}
