<?php

namespace App\Models\backend;

use CodeIgniter\Model;

class SlipPegawaiModel extends Model
{
  protected $table      = 'slip';
  protected $allowedFields = ['nogaji', 'nip', 'bulan', 'tahun', 'user_update', 'id_karyawan', 'gapok', 'tunjjabatan', 'tunjprofesi', 'tunjkinerja', 'tunjtgs', 'tunjkomunikasi', 'bkk', 'jmlhkehadiran', 'tunjkehadiran', 'jmlhpuasa', 'tunjpuasa', 'jmlhgaji', 'jmlhtunjangan', 'jmlhgator', 'spp', 'uangpangkal', 'uangkbm', 'tagihankomunikasi', 'danasosial', 'simpananpokok', 'cicilan', 'kuponbelanja', 'tabungankoperasi', 'bpjstenaga', 'bpjskesehatan', 'zakatprofesi', 'qurban', 'dll', 'jmlhpotongan', 'jmlhgajiditerima'];

  protected $useTimestamps = true;
  protected $createdField  = 'created_at';
  protected $updatedField  = 'updated_at';

  // protected $primaryKey = 'id';

  // protected $returnType     = 'array';
  // protected $useSoftDeletes = true;


  // protected $deletedField  = 'deleted_at';

  // protected $validationRules    = [];
  // protected $validationMessages = [];
  // protected $skipValidation     = false;

  public function getslipsemua()
  {
    $builder = $this->db->table($this->table);
    $builder->select('slip.*,karyawan.nama_lengkap,jabatan.jabatan');
    $builder->join('karyawan', 'karyawan.nip = slip.nip');
    $builder->join('jabatan', 'karyawan.jabatan_kode = jabatan.jabatan_kode');
    $builder->orderBy('created_at', 'DESC');
    $query = $builder->get()->getResultArray();

    return $query;
  }

  public function getSlipPersonal($id)
  {
    $builder = $this->db->table($this->table);
    $builder->select('slip.*,karyawan.nama_lengkap,jabatan.jabatan');
    $builder->join('karyawan', 'karyawan.nip = slip.nip');
    $builder->join('jabatan', 'karyawan.jabatan_kode = jabatan.jabatan_kode');
    $builder->where('slip.id', $id);
    $query = $builder->get()->getRowArray();

    return $query;
  }

  public function getslipprofil($id)
  {
    $builder = $this->db->table($this->table);
    $builder->select('slip.*,karyawan.nama_lengkap,jabatan.jabatan');
    $builder->join('karyawan', 'karyawan.nip = slip.nip');
    $builder->join('jabatan', 'karyawan.jabatan_kode = jabatan.jabatan_kode');
    $builder->where('id_karyawan', $id);
    $builder->orderBy('created_at', 'DESC');
    $query = $builder->get()->getResultArray();

    return $query;
  }
}
