<?= $this->extend('backend/layout/template_admin'); ?>

<?= $this->section('content'); ?>

<!-- /.content-header -->

<!-- Main content -->
<section class="content">
  <div class="container-fluid">
    <!-- Small boxes (Stat box) -->
    <div class="row">
      <div class="col-md-4 mb-3">
        <!-- Button trigger modal -->

        <button type="button" id="btntambahslipbaru" class="btn btn-primary" data-toggle="modal" data-target="#tambahModal">
          Tambah
        </button>
        <button type="button" name="btndeleteslip" id="btndeleteslip" class="btn btn-danger">Hapus</button>
        <button type="button" id="btnimportslip" class="btn btn-info" data-toggle="modal" data-target="#importModal">
          Import
        </button>

        <!-- modal import -->
        <div class="modal fade" id="importModal" tabindex="-1" aria-labelledby="importModalLabel" aria-hidden="true">
          <div class="modal-dialog">
            <div class="modal-content">
              <div class="modal-header">
                <h5 class="modal-title" id="importModalLabel">Import Slip Pegawai</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                  <span aria-hidden="true">&times;</span>
                </button>
              </div>
              <div class="modal-body">
                <!-- Form Tambah Data -->
                <form action="" method="POST" id="importslip" enctype="multipart/form-data">
                  <div class="form_group" style="margin-bottom: 5;">
                    <label for="">Unggah File</label>
                    <input type="file" id="fileslip" name="fileslip" class="form-control">
                  </div>
                  <br>
                  <p style="font-size: 15px;"><a href="<?= base_url(); ?>/asset/template/template_import_slip.xls">Download Template Slip pegawai</a></p>

              </div>
              <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="submit" id="btnimportsaveslip" class="btn btn-primary">Import</button>
              </div>
              </form>
            </div>
          </div>
        </div>

      </div>
      <div class="col-md-4"></div>
      <div class="col-md-4">
        <div class="form-group row">
          <label for="bulan" class="col-sm-2 col-form-label">Bulan</label>
          <div class="col-sm-4">
            <input type="text" class="form-control" id="searchbulan" name="searchbulan">
          </div>
          <label for="tahun" class="col-sm-2 col-form-label">Tahun</label>
          <div class="col-sm-4">
            <input type="text" class="form-control" id="searchtahun" name="searchtahun">
          </div>
        </div>
      </div>


    </div>


    <div class="row">
      <div class="col">
        <div class="table-responsive">
          <table class="table table-striped" id="tableSlip">
            <thead class="bg-navy">
              <tr>
                <th scope="col"></th>
                <th><input type="checkbox" id='checkall'></th>
                <!-- <th scope="col">No</th> -->
                <th scope="col">Action</th>
                <th scope="col">No Gaji</th>
                <th scope="col">NIP</th>
                <th scope="col">Nama</th>
                <th scope="col">Jabatan</th>
                <th scope="col">Bulan</th>
                <th scope="col">Tahun</th>
                <th scope="col">Gaji Pokok</th>
                <th scope="col">Tunj. Jabatan</th>
                <th scope="col">Tunj. Profesi</th>
                <th scope="col">Tunj. Kinerja</th>
                <th scope="col">Tunj. Tugas</th>
                <th scope="col">Tunj. Komunikasi</th>
                <th scope="col">bkk</th>
                <th scope="col">Jumlah Gaji</th>
                <th scope="col">Jumlah Kehadiran</th>
                <th scope="col">Tunj. Kehadiran</th>
                <th scope="col">Jumlah Puasa</th>
                <th scope="col">Tunj. Puasa</th>
                <th scope="col">Jumlah Tunjangan</th>
                <th scope="col">Gaji Kotor</th>
                <th scope="col">spp</th>
                <th scope="col">Uang Pangkal</th>
                <th scope="col">Uang KBM</th>
                <th scope="col">Tagihan Komunikasi</th>
                <th scope="col">Dana Sosial</th>
                <th scope="col">Simpanan Pokok</th>
                <th scope="col">Cicilan</th>
                <th scope="col">Kupon Belanja</th>
                <th scope="col">Tab. Koperasi</th>
                <th scope="col">BPJS Tenaga Kerja</th>
                <th scope="col">BPJS Kesehatan</th>
                <th scope="col">Zakat Profesi</th>
                <th scope="col">Qurban</th>
                <th scope="col">dll</th>
                <th scope="col">Juml. Potongan</th>
                <th scope="col">Gaji diterima</th>
                <th scope="col">Created At</th>
                <th scope="col">Updated At</th>
                <th scope="col">Last User Update</th>

              </tr>
            </thead>


          </table>
        </div>


      </div>
    </div>


    <!-- Modal Tambah Slip -->
    <div class="modal fade" id="tambahModal" tabindex="-1" aria-labelledby="tambahModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="tambahModalLabel">Tambah Slip</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form method="post" action="" id="tambahslipform">

              <div class="form-group row">
                <label for="namalengkap" class="col-sm-2 control-label">Nama Lengkap</label>
                <div class="col-sm-10">
                  <select id="namalengkap" class="form-control selectnamalengkap" name="namalengkap" onchange="tampil()">
                    <option selected disabled>Choose...</option>
                    <?php foreach ($pegawai as $pegawai) : ?>
                      <option value="<?= $pegawai['nip']; ?>"><?= $pegawai['nama_lengkap']; ?></option>
                    <?php endforeach; ?>
                  </select>
                </div>
              </div>

              <div class="form-group row">
                <label for="nip" class="col-sm-2">NIP</label>
                <div class="col-sm-10">
                  <p id="textnip">NIP Pegawai</p>
                  <input type="hidden" class="form-control" id="nip" name="nip">
                </div>
              </div>
              <div class="form-group row">
                <label for="nogaji" class="col-sm-1 col-form-label">No.Gaji</label>
                <div class="col-sm-3">
                  <input type="text" class="form-control" id="nogaji" name="nogaji" readonly>
                </div>
                <label for="bulan" class="col-sm-1 col-form-label">Bulan</label>
                <div class="col-sm-3">
                  <select id="bulan" class="form-control" name="bulan" onchange="tampil2()" disabled>
                    <option selected disabled>Choose...</option>
                    <option value="januari1">Januari Tahap 1</option>
                    <option value="januari2">Januari Tahap 2</option>
                    <option value="februari1">Februari Tahap 1</option>
                    <option value="februari2">Februari Tahap 2</option>
                    <option value="maret1">Maret Tahap 1</option>
                    <option value="maret2">Maret Tahap 2</option>
                    <option value="april1">April Tahap 1</option>
                    <option value="april2">April Tahap 2</option>
                    <option value="mei1">Mei Tahap 1</option>
                    <option value="mei2">Mei Tahap 2</option>
                    <option value="juni1">Juni Tahap 1</option>
                    <option value="juni2">Juni Tahap 2</option>
                    <option value="juli1">Juli Tahap 1</option>
                    <option value="juli2">Juli Tahap 2</option>
                    <option value="agustus1">Agustus Tahap 1</option>
                    <option value="agustus2">Agustus Tahap 2</option>
                    <option value="september1">September Tahap 1</option>
                    <option value="september2">September Tahap 2</option>
                    <option value="oktober1">Oktober Tahap 1</option>
                    <option value="oktober2">Oktober Tahap2</option>
                    <option value="november1">November Tahap 1</option>
                    <option value="november2">November Tahap 2</option>
                    <option value="desember1">Desember Tahap 1</option>
                    <option value="desember2">Desember Tahap 2</option>
                    <option value="thr">THR</option>
                    <option value="gaji13">Gaji Ke-13</option>
                  </select>

                </div>
                <label for="tahun" class="col-sm-1 col-form-label">Tahun</label>
                <div class="col-sm-3">
                  <input type="text" class="form-control" id="tahun" name="tahun">
                </div>
              </div>
              <hr>
              <div class="row">
                <center>
                  <h2 class="bg-navy">Gaji Kotor</h2>
                </center>
                <div class="col-6 content-left">
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <center><label for="gapok">Gaji Pokok</label></center>
                      <input type="text" class="form-control rupiah" id="gapok" name="gapok" value="0" onkeyup="sumgaji1();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="izin">Tunj. Jabatan</label></center>
                      <input type="text" class="form-control rupiah" id="tunjjabatan" name="tunjjabatan" value="0" onkeyup="sumgaji1();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="alpha">Tunj. Profesi</label></center>
                      <input type="text" class="form-control rupiah" id="tunjprofesi" name="tunjprofesi" value="0" onkeyup="sumgaji1();">
                    </div>

                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <center><label for="sakit">Tunj. Kinerja</label></center>
                      <input type="text" class="form-control rupiah" id="tunjkinerja" name="tunjkinerja" value="0" onkeyup="sumgaji1();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="izin">Tunj. Tugas</label></center>
                      <input type="text" class="form-control rupiah" id="tunjtgs" name="tunjtgs" value="0" onkeyup="sumgaji1();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="alpha">Tunj. Komunikasi</label></center>
                      <input type="text" class="form-control rupiah" id="tunjkomunikasi" name="tunjkomunikasi" value="0" onkeyup="sumgaji1();">
                    </div>

                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <center><label for="sakit">BKK</label></center>
                      <input type="text" class="form-control rupiah" id="bkk" name="bkk" value="0" onkeyup="sumgaji1();">
                    </div>
                  </div>
                  <div class="mb-3 row">
                    <label for="jmlhgaji" class="col-sm-3 col-form-label">Jumlah</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control rupiah" id="jmlhgaji" name="jmlhgaji" value="0" readonly>
                    </div>
                  </div>
                </div>

                <div class="col-6">
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <center><label for="sakit">Jumlah Kehadiran</label></center>
                      <input type="text" class="form-control" id="jmlhkehadiran" name="jmlhkehadiran">
                    </div>
                    <div class="form-group col-md-6">
                      <center><label for="izin">Tunj. Kehadiran</label></center>
                      <input type="text" class="form-control rupiah" id="tunjkehadiran" name="tunjkehadiran" value="0" onkeyup="sumgaji1();">
                    </div>
                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <center><label for="sakit">Jumlah Puasa</label></center>
                      <input type="text" class="form-control rupiah" id="jmlhpuasa" name="jmlhpuasa">
                    </div>
                    <div class="form-group col-md-6">
                      <center><label for="izin">Tunj. Puasa</label></center>
                      <input type="text" class="form-control rupiah" id="tunjpuasa" name="tunjpuasa" value="0" onkeyup="sumgaji1();">
                    </div>
                  </div>

                  <div class="mb-3 row">
                    <label for="jmlhtunjangan" class="col-sm-3 col-form-label">Jumlah</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control rupiah" id="jmlhtunjangan" name="jmlhtunjangan" value="0" readonly>
                    </div>
                  </div>
                  <div class="mb-3 row">
                    <label for="jmlhgajikotor" class="col-sm-3 col-form-label">Jumlah Gaji Kotor</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control bg-primary" id="jmlhgator" name="jmlhgator" value="0" readonly>
                    </div>
                  </div>
                </div>
              </div>
              <hr>
              <center>
                <h2 class="bg-navy">Potongan</h2>
              </center>
              <div class="form-row">
                <div class="form-group col-md-2">
                  <center><label for="spp">SPP</label></center>
                  <input type="text" class="form-control rupiah" id="spp" name="spp" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="uangpangkal">Uang Pangkal</label></center>
                  <input type="text" class="form-control rupiah" id="uangpangkal" name="uangpangkal" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="Uang KBM">Uang KBM</label></center>
                  <input type="text" class="form-control rupiah" id="uangkbm" name="uangkbm" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="tagihankomunikasi">Tagihan Komunikasi</label></center>
                  <input type="text" class="form-control rupiah" id="tagihankomunikasi" name="tagihankomunikasi" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="danasosial">Dana Sosial</label></center>
                  <input type="text" class="form-control rupiah" id="danasosial" name="danasosial" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="simpananpokok">Simpanan Pokok</label></center>
                  <input type="text" class="form-control rupiah" id="simpananpokok" name="simpananpokok" value="0" onkeyup="sumgaji1();">
                </div>

              </div>
              <div class="form-row">
                <div class="form-group col-md-2">
                  <center><label for="cicilan">Cicilan Pinjaman</label></center>
                  <input type="text" class="form-control rupiah" id="cicilan" name="cicilan" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="kuponbelanja">Kupon Belanja</label></center>
                  <input type="text" class="form-control rupiah" id="kuponbelanja" name="kuponbelanja" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="tabungankoperasi">Tabungan Koperasi</label></center>
                  <input type="text" class="form-control rupiah" id="tabungankoperasi" name="tabungankoperasi" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="bpjstenaga">BPJS Tenaga Kerja</label></center>
                  <input type="text" class="form-control rupiah" id="bpjstenaga" name="bpjstenaga" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="bpjskesehatan">BPJS Kesehatan</label></center>
                  <input type="text" class="form-control rupiah" id="bpjskesehatan" name="bpjskesehatan" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="zakatprofesi">Zakat Profesi</label></center>
                  <input type="text" class="form-control rupiah" id="zakatprofesi" name="zakatprofesi" value="0" onkeyup="sumgaji1();">
                </div>

              </div>
              <div class="form-row">
                <div class="form-group col-md-2">
                  <center><label for="qurban">Tabungan Qurban</label></center>
                  <input type="text" class="form-control rupiah" id="qurban" name="qurban" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="dll">DLL</label></center>
                  <input type="text" class="form-control rupiah" id="dll" name="dll" value="0" onkeyup="sumgaji1();">
                </div>
                <div class="form-group col-md-4">
                  <center><label for="jumlah">Jumlah</label></center>
                  <input type="text" class="form-control bg-primary rupiah" id="jmlhpotongan" name="jmlhpotongan" value="0" readonly>
                </div>
              </div>
              <hr>
              <center>
                <h2 class="bg-navy">Kesimpulan</h2>
              </center>
              <div class="mb-3 row">
                <label for="jmlhgajiditerima" class="col-sm-3 col-form-label">Jumlah Gaji Diterima</label>
                <div class="col-sm-6">
                  <input type="text" class="form-control bg-primary rupiah" id="jmlhgajiditerima" name="jmlhgajiditerima" value="0" readonly>
                </div>
              </div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btnsaveslip" class="btn btn-primary">Tambah</button>
          </div>
          </form>
        </div>
      </div>
    </div>

    <!-- Modal Edit SLip -->
    <div class="modal fade" id="editslipModal" tabindex="-1" aria-labelledby="editslipModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-xl">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editslipModalLabel">Edit Slip</h5>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
              <span aria-hidden="true">&times;</span>
            </button>
          </div>
          <div class="modal-body">
            <form method="post" action="" id="editslipform">
              <input type="hidden" name="idslip">

              <div class="form-group row">
                <label for="namalengkap" class="col-sm-2">Nama Lengkap</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="editnamalengkap" name="namalengkap" readonly>
                </div>
              </div>
              <div class="form-group row">
                <label for="nip" class="col-sm-2">NIP</label>
                <div class="col-sm-10">
                  <input type="text" class="form-control" id="editnip" name="nip" readonly>
                </div>
              </div>

              <div class="form-group row">
                <label for="nogaji" class="col-sm-1 col-form-label">No.Gaji</label>
                <div class="col-sm-3">
                  <input type="text" class="form-control" id="editnogaji" name="nogaji" readonly>
                </div>

                <label for="bulan" class="col-sm-1 col-form-label">Bulan</label>
                <div class="col-sm-3">
                  <select id="editbulan" class="form-control" name="bulan">
                    <option selected disabled>Choose...</option>
                    <option value="januari">Januari</option>
                    <option value="februari">Februari</option>
                    <option value="maret">Maret</option>
                    <option value="april">April</option>
                    <option value="mei">Mei</option>
                    <option value="juni">Juni</option>
                    <option value="juli">Juli</option>
                    <option value="agustus">Agustus</option>
                    <option value="september">September</option>
                    <option value="oktober">Oktober</option>
                    <option value="november">November</option>
                    <option value="desember">Desember</option>
                    <option value="thr">THR</option>
                    <option value="gaji13">Gaji Ke-13</option>
                  </select>

                </div>
                <label for="tahun" class="col-sm-1 col-form-label">Tahun</label>
                <div class="col-sm-3">
                  <input type="text" class="form-control" id="edittahun" name="tahun">
                </div>
              </div>
              <hr>
              <div class="row">
                <center>
                  <h2 class="bg-navy">Gaji Kotor</h2>
                </center>
                <div class="col-6 content-left">
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <center><label for="gapok">Gaji Pokok</label></center>
                      <input type="text" class="form-control rupiah" id="editgapok" name="gapok" value="0" onkeyup="sumgaji2();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="izin">Tunj. Jabatan</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjjabatan" name="tunjjabatan" value="0" onkeyup="sumgaji2();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="alpha">Tunj. Profesi</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjprofesi" name="tunjprofesi" value="0" onkeyup="sumgaji2();">
                    </div>

                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <center><label for="sakit">Tunj. Kinerja</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjkinerja" name="tunjkinerja" value="0" onkeyup="sumgaji2();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="izin">Tunj. Tugas</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjtgs" name="tunjtgs" value="0" onkeyup="sumgaji2();">
                    </div>
                    <div class="form-group col-md-4">
                      <center><label for="alpha">Tunj. Komunikasi</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjkomunikasi" name="tunjkomunikasi" value="0" onkeyup="sumgaji2();">
                    </div>

                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-4">
                      <center><label for="sakit">BKK</label></center>
                      <input type="text" class="form-control rupiah" id="editbkk" name="bkk" value="0" onkeyup="sumgaji2();">
                    </div>
                  </div>
                  <div class="mb-3 row">
                    <label for="jmlhgaji" class="col-sm-3 col-form-label">Jumlah</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control rupiah" id="editjmlhgaji" name="jmlhgaji" value="0" readonly>
                    </div>
                  </div>
                </div>

                <div class="col-6">
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <center><label for="sakit">Jumlah Kehadiran</label></center>
                      <input type="text" class="form-control" id="editjmlhkehadiran" name="jmlhkehadiran">
                    </div>
                    <div class="form-group col-md-6">
                      <center><label for="izin">Tunj. Kehadiran</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjkehadiran" name="tunjkehadiran" value="0" onkeyup="sumgaji2();">
                    </div>
                  </div>
                  <div class="form-row">
                    <div class="form-group col-md-6">
                      <center><label for="sakit">Jumlah Puasa</label></center>
                      <input type="text" class="form-control rupiah" id="editjmlhpuasa" name="jmlhpuasa">
                    </div>
                    <div class="form-group col-md-6">
                      <center><label for="izin">Tunj. Puasa</label></center>
                      <input type="text" class="form-control rupiah" id="edittunjpuasa" name="tunjpuasa" value="0" onkeyup="sumgaji2();">
                    </div>
                  </div>

                  <div class="mb-3 row">
                    <label for="jmlhtunjangan" class="col-sm-3 col-form-label">Jumlah</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control rupiah" id="editjmlhtunjangan" name="jmlhtunjangan" value="0" readonly>
                    </div>
                  </div>
                  <div class="mb-3 row">
                    <label for="jmlhgajikotor" class="col-sm-3 col-form-label">Jumlah Gaji Kotor</label>
                    <div class="col-sm-9">
                      <input type="text" class="form-control bg-primary" id="editjmlhgator" name="jmlhgator" value="0" readonly>
                    </div>
                  </div>
                </div>
              </div>
              <hr>
              <center>
                <h2 class="bg-navy">Potongan</h2>
              </center>
              <div class="form-row">
                <div class="form-group col-md-2">
                  <center><label for="spp">SPP</label></center>
                  <input type="text" class="form-control rupiah" id="editspp" name="spp" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="uangpangkal">Uang Pangkal</label></center>
                  <input type="text" class="form-control rupiah" id="edituangpangkal" name="uangpangkal" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="Uang KBM">Uang KBM</label></center>
                  <input type="text" class="form-control rupiah" id="edituangkbm" name="uangkbm" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="tagihankomunikasi">Tagihan Komunikasi</label></center>
                  <input type="text" class="form-control rupiah" id="edittagihankomunikasi" name="tagihankomunikasi" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="danasosial">Dana Sosial</label></center>
                  <input type="text" class="form-control rupiah" id="editdanasosial" name="danasosial" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="simpananpokok">Simpanan Pokok</label></center>
                  <input type="text" class="form-control rupiah" id="editsimpananpokok" name="simpananpokok" value="0" onkeyup="sumgaji2();">
                </div>

              </div>
              <div class="form-row">
                <div class="form-group col-md-2">
                  <center><label for="cicilan">Cicilan Pinjaman</label></center>
                  <input type="text" class="form-control rupiah" id="editcicilan" name="cicilan" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="kuponbelanja">Kupon Belanja</label></center>
                  <input type="text" class="form-control rupiah" id="editkuponbelanja" name="kuponbelanja" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="tabungankoperasi">Tabungan Koperasi</label></center>
                  <input type="text" class="form-control rupiah" id="edittabungankoperasi" name="tabungankoperasi" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="bpjstenaga">BPJS Tenaga Kerja</label></center>
                  <input type="text" class="form-control rupiah" id="editbpjstenaga" name="bpjstenaga" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="bpjskesehatan">BPJS Kesehatan</label></center>
                  <input type="text" class="form-control rupiah" id="editbpjskesehatan" name="bpjskesehatan" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="zakatprofesi">Zakat Profesi</label></center>
                  <input type="text" class="form-control rupiah" id="editzakatprofesi" name="zakatprofesi" value="0" onkeyup="sumgaji2();">
                </div>

              </div>
              <div class="form-row">
                <div class="form-group col-md-2">
                  <center><label for="qurban">Tabungan Qurban</label></center>
                  <input type="text" class="form-control rupiah" id="editqurban" name="qurban" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-2">
                  <center><label for="dll">DLL</label></center>
                  <input type="text" class="form-control rupiah" id="editdll" name="dll" value="0" onkeyup="sumgaji2();">
                </div>
                <div class="form-group col-md-4">
                  <center><label for="jumlah">Jumlah</label></center>
                  <input type="text" class="form-control bg-primary rupiah" id="editjmlhpotongan" name="jmlhpotongan" value="0" readonly>
                </div>
              </div>
              <hr>
              <center>
                <h2 class="bg-navy">Kesimpulan</h2>
              </center>
              <div class="mb-3 row">
                <label for="jmlhgajiditerima" class="col-sm-3 col-form-label">Jumlah Gaji Diterima</label>
                <div class="col-sm-6">
                  <input type="text" class="form-control bg-primary rupiah" id="editjmlhgajiditerima" name="jmlhgajiditerima" value="0" readonly>
                </div>
              </div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
            <button type="submit" id="btnupdateslip" class="btn btn-primary">Update</button>
          </div>
          </form>
        </div>
      </div>
    </div>

  </div><!-- /.container-fluid -->
</section>
<!-- /.content -->
</div>
<!-- /.content-wrapper -->

<script>
  function tampil() {
    date = new Date();
    let hari = (date.getDate() < 10 ? '0' : '') + date.getDate();
    let bulan = ((date.getMonth() + 1) < 10 ? '0' : '') + (date.getMonth() + 1);
    let tahun = date.getFullYear();

    let nip = document.getElementById("namalengkap").value;
    // let bulan = document.getElementById("bulan").value;
    // console.log(nip)
    document.getElementById("textnip").innerHTML = nip;
    document.getElementById("nip").value = nip;

    // document.getElementById("bulan").removeAttribute("disable");
    document.getElementById('bulan').disabled = false;
    // document.getElementById("bulan").value = bulan;
    // document.getElementById("nogaji").value = tahun + "" + bulan + "" + hari + "" + bulan.slice(-3) + "" + nip.slice(-4);
    // document.getElementById("nogaji").value = tahun + "" + bulan + "" + hari + "" + nip.slice(-4);

  }

  function tampil2() {
    date = new Date();
    let hari = (date.getDate() < 10 ? '0' : '') + date.getDate();
    let bulan = ((date.getMonth() + 1) < 10 ? '0' : '') + (date.getMonth() + 1);
    let tahun = date.getFullYear();

    let nip = document.getElementById("namalengkap").value;
    let bulan2 = document.getElementById("bulan").value;
    // console.log(nip)
    // document.getElementById("textnip").innerHTML = nip;
    // document.getElementById("nip").value = nip;
    // document.getElementById("bulan").value = bulan;
    document.getElementById("nogaji").value = tahun + "" + bulan + "" + hari + "" + bulan2.substr(0, 3).toUpperCase() + ""+ bulan2.slice(-1).toUpperCase() + "" + nip.slice(-4);
    // document.getElementById("nogaji").value = tahun + "" + bulan + "" + hari + "" + nip.slice(-4);

  }
</script>

<script type="text/javascript">
  let rupiah = document.getElementsByClassName('rupiah');

  for (var i = 0; i < rupiah.length; i++) {

    rupiah[i].addEventListener('keyup', function(e) {
      // tambahkan 'Rp.' pada saat form di ketik
      // gunakan fungsi formatRupiah() untuk mengubah angka yang di ketik menjadi format angka
      this.value = formatRupiah(this.value);
    });
  }



  /* Fungsi formatRupiah */
  function formatRupiah(angka) {
    var number_string = angka.toString().replace(/[^,\d]/g, ''),
      split = number_string.split(','),
      sisa = split[0].length % 3,
      rupiah = split[0].substr(0, sisa),
      ribuan = split[0].substr(sisa).match(/\d{1,3}/gi);

    // tambahkan titik jika yang di input sudah menjadi angka ribuan
    if (ribuan) {
      separator = sisa ? '.' : '';
      rupiah += separator + ribuan.join('.');
    }

    rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
    return rupiah == undefined ? rupiah : (rupiah ? '' + rupiah : '');
  }

  function hilangtitik(angka) {
    let angkabaru = angka.toString().replace(/[^,\d]/g, "");

    return angkabaru;
  }

  function sumgaji1() {
    let gapok = hilangtitik(document.getElementById('gapok').value);
    let tunjjabatan = hilangtitik(document.getElementById('tunjjabatan').value);
    let tunjprofesi = hilangtitik(document.getElementById('tunjprofesi').value);
    let tunjkinerja = hilangtitik(document.getElementById('tunjkinerja').value);
    let tunjtgs = hilangtitik(document.getElementById('tunjtgs').value);
    let tunjkomunikasi = hilangtitik(document.getElementById('tunjkomunikasi').value);
    let bkk = hilangtitik(document.getElementById('bkk').value);


    let tunjkehadiran = hilangtitik(document.getElementById('tunjkehadiran').value);
    let tunjpuasa = hilangtitik(document.getElementById('tunjpuasa').value);

    let spp = hilangtitik(document.getElementById('spp').value);
    let uangpangkal = hilangtitik(document.getElementById('uangpangkal').value);
    let uangkbm = hilangtitik(document.getElementById('uangkbm').value);
    let tagihankomunikasi = hilangtitik(document.getElementById('tagihankomunikasi').value);
    let danasosial = hilangtitik(document.getElementById('danasosial').value);
    let simpananpokok = hilangtitik(document.getElementById('simpananpokok').value);
    let cicilan = hilangtitik(document.getElementById('cicilan').value);
    let kuponbelanja = hilangtitik(document.getElementById('kuponbelanja').value);
    let tabungankoperasi = hilangtitik(document.getElementById('tabungankoperasi').value);
    let bpjstenaga = hilangtitik(document.getElementById('bpjstenaga').value);
    let bpjskesehatan = hilangtitik(document.getElementById('bpjskesehatan').value);
    let zakatprofesi = hilangtitik(document.getElementById('zakatprofesi').value);
    let qurban = hilangtitik(document.getElementById('qurban').value);
    let dll = hilangtitik(document.getElementById('dll').value);

    let jmlhpotongan = parseInt(spp) + parseInt(uangpangkal) + parseInt(uangkbm) + parseInt(tagihankomunikasi) + parseInt(danasosial) + parseInt(simpananpokok) + parseInt(cicilan) + parseInt(kuponbelanja) + parseInt(tabungankoperasi) + parseInt(bpjstenaga) + parseInt(bpjskesehatan) + parseInt(zakatprofesi) + parseInt(qurban) + parseInt(dll);
    if (!isNaN(jmlhpotongan)) {
      document.getElementById('jmlhpotongan').value = formatRupiah(jmlhpotongan);
    }

    let jmlhgaji1 = parseInt(gapok) + parseInt(tunjjabatan) + parseInt(tunjprofesi) + parseInt(tunjkinerja) + parseInt(tunjtgs) + parseInt(tunjkomunikasi) + parseInt(bkk);
    if (!isNaN(jmlhgaji1)) {
      document.getElementById('jmlhgaji').value = formatRupiah(jmlhgaji1);
    }

    let jmlhgaji2 = parseInt(tunjkehadiran) + parseInt(tunjpuasa);
    if (!isNaN(jmlhgaji2)) {
      document.getElementById('jmlhtunjangan').value = formatRupiah(jmlhgaji2);
    }

    let jmlhgajikotor = jmlhgaji1 + jmlhgaji2;
    if (!isNaN(jmlhgajikotor)) {
      document.getElementById('jmlhgator').value = formatRupiah(jmlhgajikotor);
    }

    let jmlhgajiditerima = jmlhgaji1 + jmlhgaji2 - jmlhpotongan;
    if (!isNaN(jmlhgajiditerima)) {
      document.getElementById('jmlhgajiditerima').value = formatRupiah(jmlhgajiditerima);
    }

  }

  function sumgaji2() {
    let gapok = hilangtitik(document.getElementById('editgapok').value);
    let tunjjabatan = hilangtitik(document.getElementById('edittunjjabatan').value);
    let tunjprofesi = hilangtitik(document.getElementById('edittunjprofesi').value);
    let tunjkinerja = hilangtitik(document.getElementById('edittunjkinerja').value);
    let tunjtgs = hilangtitik(document.getElementById('edittunjtgs').value);
    let tunjkomunikasi = hilangtitik(document.getElementById('edittunjkomunikasi').value);
    let bkk = hilangtitik(document.getElementById('editbkk').value);


    let tunjkehadiran = hilangtitik(document.getElementById('edittunjkehadiran').value);
    let tunjpuasa = hilangtitik(document.getElementById('edittunjpuasa').value);

    let spp = hilangtitik(document.getElementById('editspp').value);
    let uangpangkal = hilangtitik(document.getElementById('edituangpangkal').value);
    let uangkbm = hilangtitik(document.getElementById('edituangkbm').value);
    let tagihankomunikasi = hilangtitik(document.getElementById('edittagihankomunikasi').value);
    let danasosial = hilangtitik(document.getElementById('editdanasosial').value);
    let simpananpokok = hilangtitik(document.getElementById('editsimpananpokok').value);
    let cicilan = hilangtitik(document.getElementById('editcicilan').value);
    let kuponbelanja = hilangtitik(document.getElementById('editkuponbelanja').value);
    let tabungankoperasi = hilangtitik(document.getElementById('edittabungankoperasi').value);
    let bpjstenaga = hilangtitik(document.getElementById('editbpjstenaga').value);
    let bpjskesehatan = hilangtitik(document.getElementById('editbpjskesehatan').value);
    let zakatprofesi = hilangtitik(document.getElementById('editzakatprofesi').value);
    let qurban = hilangtitik(document.getElementById('editqurban').value);
    let dll = hilangtitik(document.getElementById('editdll').value);

    let jmlhpotongan = parseInt(spp) + parseInt(uangpangkal) + parseInt(uangkbm) + parseInt(tagihankomunikasi) + parseInt(danasosial) + parseInt(simpananpokok) + parseInt(cicilan) + parseInt(kuponbelanja) + parseInt(tabungankoperasi) + parseInt(bpjstenaga) + parseInt(bpjskesehatan) + parseInt(zakatprofesi) + parseInt(qurban) + parseInt(dll);
    if (!isNaN(jmlhpotongan)) {
      document.getElementById('editjmlhpotongan').value = formatRupiah(jmlhpotongan);
    }

    let jmlhgaji1 = parseInt(gapok) + parseInt(tunjjabatan) + parseInt(tunjprofesi) + parseInt(tunjkinerja) + parseInt(tunjtgs) + parseInt(tunjkomunikasi) + parseInt(bkk);
    if (!isNaN(jmlhgaji1)) {
      document.getElementById('editjmlhgaji').value = formatRupiah(jmlhgaji1);
    }

    let jmlhgaji2 = parseInt(tunjkehadiran) + parseInt(tunjpuasa);
    if (!isNaN(jmlhgaji2)) {
      document.getElementById('editjmlhtunjangan').value = formatRupiah(jmlhgaji2);
    }

    let jmlhgajikotor = jmlhgaji1 + jmlhgaji2;
    if (!isNaN(jmlhgajikotor)) {
      document.getElementById('editjmlhgator').value = formatRupiah(jmlhgajikotor);
    }

    let jmlhgajiditerima = jmlhgaji1 + jmlhgaji2 - jmlhpotongan;
    if (!isNaN(jmlhgajiditerima)) {
      document.getElementById('editjmlhgajiditerima').value = formatRupiah(jmlhgajiditerima);
    }

  }
</script>

<script>
  $(document).ready(function() {

    $('.selectnamalengkap').select2({
      theme: "bootstrap"
    });


    function tabelslip(dataks) {
      $('#tableSlip').DataTable({
        "data": dataks,
        "responsive": true,
        "dom": "<'row'<'col-sm-12 col-md-4'l><'col-sm-12 col-md-4'B><'col-sm-12 col-md-4'f>>" +
          "<'row'<'col-sm-12'tr>>" +
          "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
        "buttons": [{
            extend: 'copyHtml5',
            text: '<i class="far fa-fw fa-copy"></i>',
            titleAttr: 'Copy'
          },
          {
            extend: 'excelHtml5',
            text: '<i class="far fa-fw fa-file-excel"></i>',
            titleAttr: 'Excel'
          },
          {
            extend: 'pdfHtml5',
            text: '<i class="far fa-fw fa-file-pdf"></i>',
            titleAttr: 'Pdf'
          },
          {
            extend: 'print',
            text: '<i class="fas fa-fw fa-print"></i>',
            titleAttr: 'Print'
          },
          {
            extend: 'colvis',
            text: '',
            titleAttr: 'Colvis'
          }
        ],

        columnDefs: [{
          targets: [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36],
          visible: false
        }],

        "columns": [{
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              return a;
            }
          },
          {
            targets: 0,
            data: null,
            className: 'text-center',
            searchable: false,
            orderable: false,

            "render": function(data, type, row, meta) {
              var r =
                '<input type="checkbox" name="deletecheckbox" id = "' + row.id + '"  value = "' + row.id + '" class="deletecheckbox"></input>';

              return r;
            },
          },
          {
            "data": null,
            "render": function(data, type, row, meta) {
              let a = '';
              a = `
                            <center><a href="" class="badge badge-info editslippegawai" value="${row.id}"><i class="far fa-fw fa-edit"></i></a>
                            <a href="<?= base_url(); ?>/keuangan/detailslip/${row.id}&${row.id_karyawan}" class="badge badge-success detailslip" target="blank"><i class="fas fa-fw fa-search"></i></a>
                           
                            <a href="<?= base_url(); ?>/keuangan/pdfdetailslip/${row.id}&${row.id_karyawan}" target="_blank" class="badge badge-warning"><i class="fas fa-fw fa-download"></i></a>
                            </center>`

              return a;
            }
          },

          {
            "data": "nogaji"
          },
          {
            "data": "nip"
          },
          {
            "data": "nama_lengkap"
          },
          {
            "data": "jabatan"
          },
          {
            "data": "bulan"
          },
          {
            "data": "tahun"
          },
          {
            "data": "gapok"
          },
          {
            "data": "tunjjabatan"
          },
          {
            "data": "tunjprofesi"
          },
          {
            "data": "tunjkinerja"
          },
          {
            "data": "tunjtgs"
          },
          {
            "data": "tunjkomunikasi"
          },
          {
            "data": "bkk"
          },
          {
            "data": "jmlhgaji"
          },
          {
            "data": "jmlhkehadiran"
          },
          {
            "data": "tunjkehadiran"
          },
          {
            "data": "jmlhpuasa"
          },
          {
            "data": "tunjpuasa"
          },
          {
            "data": "jmlhtunjangan"
          },
          {
            "data": "jmlhgator"
          },
          {
            "data": "spp"
          },
          {
            "data": "uangpangkal"
          },
          {
            "data": "uangkbm"
          },
          {
            "data": "tagihankomunikasi"
          },
          {
            "data": "danasosial"
          },
          {
            "data": "simpananpokok"
          },
          {
            "data": "cicilan"
          },
          {
            "data": "kuponbelanja"
          },
          {
            "data": "tabungankoperasi"
          },
          {
            "data": "bpjstenaga"
          },
          {
            "data": "bpjskesehatan"
          },
          {
            "data": "zakatprofesi"
          },
          {
            "data": "qurban"
          },
          {
            "data": "dll"
          },
          {
            "data": "jmlhpotongan"
          },
          {
            "data": "jmlhgajiditerima"
          },

          {
            "data": "created_at"
          },
          {
            "data": "updated_at"
          },
          {
            "data": "user_update"

          }

        ],

      });
    }


    //fungsi fetch absen
    function fetchslippegawai() {
      $.ajax({
        url: '<?= base_url(); ?>/keuangan/fetchslippegawai',
        type: 'post',
        dataType: 'json',
        success: function(data) {
          // console.log(data);
          let i = "1";
          tabelslip(data.slip);
        }
      });
    }

    fetchslippegawai();

    // #column3_search is a <input type="text"> element
    $('#searchbulan').on('keyup', function() {
      $('#tableSlip').DataTable()
        .columns(7)
        .search(this.value)
        .draw();
    });

    $('#searchtahun').on('keyup', function() {
      $('#tableSlip').DataTable()
        .columns(8)
        .search(this.value)
        .draw();
    });

    $(document).on('click', '#btntambahslipbaru', function() {
      $('#tambahslipform')[0].reset();
    })

    $(document).on('click', '#btnimportslip', function() {
      $('#importslip')[0].reset();
    })

    // tambah slip
    $('#tambahslipform').submit(function() {
      event.preventDefault();

      $.ajax({
        url: '<?= base_url('/keuangan/saveslippegawai'); ?>',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btnsaveslip').attr('disabled');
          $("#btnsaveslip").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {
            $('#tambahModal').modal('hide');
            $('#tableSlip').DataTable().destroy();

            fetchslippegawai();
            toastr["success"](data.pesan);
          } else {
            // console.log(data);
            toastr["error"](data.pesan);
          }
        },
        complete: function() {
          $('#btnsaveslip').removeAttr('disabled');
          $("#btnsaveslip").html(`Simpan`);

        },
      });
    });

    // modal edit
    $(document).on("click", ".editslippegawai", function() {
      event.preventDefault();
      $("#editbulan").children().remove();
      let idslip = $(this).attr("value")
      $.ajax({
        url: '<?= base_url('/keuangan/editmodalslip'); ?>',
        type: 'post',
        data: {
          idslip: idslip
        },
        dataType: 'json',
        success: function(data) {
          if (data.responce == 'success') {
            // console.log(data);
            $('#editslipModal').modal('show');
            $("input[name='idslip']").val(data.slip.id);


            $("input[name='namalengkap']").val(data.slip.nama_lengkap);
            $("input[name='nip']").val(data.slip.nip);
            $("input[name='nogaji']").val(data.slip.nogaji);



            $("#editbulan").append('<option value="januari"' + ((data.slip.bulan == 'januari') ? 'selected="selected"' : '') + '>Januari</option>');
            $("#editbulan").append('<option value="februari"' + ((data.slip.bulan == 'februari') ? 'selected="selected"' : '') + '>Februari</option>');
            $("#editbulan").append('<option value="maret"' + ((data.slip.bulan == 'maret') ? 'selected="selected"' : '') + '>Maret</option>');
            $("#editbulan").append('<option value="april"' + ((data.slip.bulan == 'april') ? 'selected="selected"' : '') + '>April</option>');
            $("#editbulan").append('<option value="mei"' + ((data.slip.bulan == 'mei') ? 'selected="selected"' : '') + '>Mei</option>');
            $("#editbulan").append('<option value="juni"' + ((data.slip.bulan == 'juni') ? 'selected="selected"' : '') + '>Juni</option>');
            $("#editbulan").append('<option value="juli"' + ((data.slip.bulan == 'juli') ? 'selected="selected"' : '') + '>Juli</option>');
            $("#editbulan").append('<option value="agustus"' + ((data.slip.bulan == 'agustus') ? 'selected="selected"' : '') + '>Agustus</option>');
            $("#editbulan").append('<option value="september"' + ((data.slip.bulan == 'september') ? 'selected="selected"' : '') + '>September</option>');
            $("#editbulan").append('<option value="oktober"' + ((data.slip.bulan == 'oktober') ? 'selected="selected"' : '') + '>Oktober</option>');
            $("#editbulan").append('<option value="november"' + ((data.slip.bulan == 'november') ? 'selected="selected"' : '') + '>November</option>');
            $("#editbulan").append('<option value="desember"' + ((data.slip.bulan == 'desember') ? 'selected="selected"' : '') + '>Desember</option>');
            $("#editbulan").append('<option value="thr"' + ((data.slip.bulan == 'thr') ? 'selected="selected"' : '') + '>THR</option>');
            $("#editbulan").append('<option value="gaji13"' + ((data.slip.bulan == 'gaji13') ? 'selected="selected"' : '') + '>Gaji Ke-13</option>');


            $("input[name='tahun']").val(data.slip.tahun);

            $("input[name='gapok']").val(formatRupiah(data.slip.gapok));
            $("input[name='tunjjabatan']").val(formatRupiah(data.slip.tunjjabatan));
            $("input[name='tunjprofesi']").val(formatRupiah(data.slip.tunjprofesi));
            $("input[name='tunjkinerja']").val(formatRupiah(data.slip.tunjkinerja));
            $("input[name='tunjtgs']").val(formatRupiah(data.slip.tunjtgs));
            $("input[name='tunjkomunikasi']").val(formatRupiah(data.slip.tunjkomunikasi));
            $("input[name='bkk']").val(formatRupiah(data.slip.bkk));
            $("input[name='jmlhgaji']").val(formatRupiah(data.slip.jmlhgaji));
            $("input[name='jmlhkehadiran']").val(data.slip.jmlhkehadiran);
            $("input[name='jmlhpuasa']").val(data.slip.jmlhpuasa);
            $("input[name='tunjkehadiran']").val(formatRupiah(data.slip.tunjkehadiran));
            $("input[name='tunjpuasa']").val(formatRupiah(data.slip.tunjpuasa));
            $("input[name='jmlhtunjangan']").val(formatRupiah(data.slip.jmlhtunjangan));
            $("input[name='jmlhgator']").val(formatRupiah(data.slip.jmlhgator));
            $("input[name='spp']").val(formatRupiah(data.slip.spp));
            $("input[name='uangpangkal']").val(formatRupiah(data.slip.uangpangkal));
            $("input[name='uangkbm']").val(formatRupiah(data.slip.uangkbm));
            $("input[name='tagihankomunikasi']").val(formatRupiah(data.slip.tagihankomunikasi));
            $("input[name='danasosial']").val(formatRupiah(data.slip.danasosial));
            $("input[name='simpananpokok']").val(formatRupiah(data.slip.simpananpokok));
            $("input[name='cicilan']").val(formatRupiah(data.slip.cicilan));
            $("input[name='kuponbelanja']").val(formatRupiah(data.slip.kuponbelanja));
            $("input[name='tabungankoperasi']").val(formatRupiah(data.slip.tabungankoperasi));
            $("input[name='bpjstenaga']").val(formatRupiah(data.slip.bpjstenaga));
            $("input[name='bpjskesehatan']").val(formatRupiah(data.slip.bpjskesehatan));
            $("input[name='zakatprofesi']").val(formatRupiah(data.slip.zakatprofesi));
            $("input[name='qurban']").val(formatRupiah(data.slip.qurban));
            $("input[name='dll']").val(formatRupiah(data.slip.dll));
            $("input[name='jmlhpotongan']").val(formatRupiah(data.slip.jmlhpotongan));
            $("input[name='jmlhgajiditerima']").val(formatRupiah(data.slip.jmlhgajiditerima));


          } else {

            toastr["error"](data.pesan);
          }

        }
      });
    });

    // edit slip

    $("#editslipform").submit(function(event) {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url(); ?>/keuangan/editslippegawai',
        type: 'post',
        data: $(this).serialize(),
        dataType: 'json',
        beforeSend: function() {
          // setting a timeout
          $('#btnupdateslip').attr('disabled');
          $("#btnupdateslip").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          // console.log(data);
          if (data.responce == "success") {
            $('#editslipModal').modal('hide');
            $('#tableSlip').DataTable().destroy();
            fetchslippegawai();
            toastr["success"](data.pesan);
          } else {
            toastr["error"](data.pesan);
          }
          $('#tambahslipform')[0].reset();
        },
        complete: function() {
          $('#btnupdateslip').removeAttr('disabled');
          $("#btnupdateslip").html(`Update`);

        },

      });
    })

    // Check all 
    $('#checkall').click(function() {
      if ($(this).is(':checked')) {
        $('.deletecheckbox').prop('checked', true);
      } else {
        $('.deletecheckbox').prop('checked', false);
      }
    });

    $('.deletecheckbox').click(function() {
      if ($(this).is(':checked')) {
        $(this).closest('tr').addClass('removeRow');
      } else {
        $(this).closest('tr').removeClass('removeRow');
      }
    });


    $('#btndeleteslip').click(function() {
      let checkbox = $('.deletecheckbox:checked');

      if (checkbox.length > 0) {
        Swal.fire({
          title: 'Apa kamu yakin ingin menghapus ' + checkbox.length + ' slip pegawai?',
          text: "kamu tidak akan bisa mengembalikannya!",
          icon: 'warning',
          showCancelButton: true,
          confirmButtonColor: '#3085d6',
          cancelButtonColor: '#d33',
          confirmButtonText: 'Ya, hapus saja!'
        }).then((result) => {
          if (result.isConfirmed) {

            let checkbox_value = [];
            $(checkbox).each(function() {
              checkbox_value.push($(this).val());
            });

            // console.log(checkbox);
            $.ajax({
              url: '<?= base_url('/keuangan/deleteslippegawai'); ?>',
              type: "POST",
              data: {
                checkbox_value: checkbox_value
              },
              dataType: 'json',
              success: function(data) {
                if (data.responce == "success") {

                  Swal.fire(
                    'Deleted!',
                    'Data berhasil dihapus.',
                    'success'
                  )
                  $('#tableSlip').DataTable().destroy();
                  fetchslippegawai();
                } else {
                  Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Ada yang tidak beres!',
                  })
                }
              }
            })

          }
        })

      } else {
        Swal.fire({
          icon: 'error',
          title: 'Oops...',
          text: 'Pilih minimal satu data',
        })

      }
    });



    // import slip
    $('#importslip').submit(function() {
      event.preventDefault();
      $.ajax({
        url: '<?= base_url('/keuangan/importslippegawai'); ?>',
        type: 'post',
        data: new FormData(this),
        dataType: 'json',
        cache: false,
        processData: false,
        contentType: false,
        beforeSend: function() {
          // setting a timeout
          $('#btnimportsaveslip').attr('disabled');
          $("#btnimportsaveslip").html(`<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>`);

        },
        success: function(data) {
          if (data.responce == "success") {

            $('#tableSlip').DataTable().destroy();
            fetchslippegawai();
            $('#importModal').modal('hide');
            toastr["success"](data.pesan);

          } else if (data.responce == "errorkosong") {

            $('#importModal').modal('hide');
            Swal.fire({
              icon: 'error',
              title: 'Oops...',
              text: 'Nip tidak ada di database pada baris ' + data.barisgagal
            })

          } else {
            // console.log(data);
            toastr["error"](data.pesan);
            console.log(data.pesan);
          }
        },
        complete: function() {
          $('#btnimportsaveslip').removeAttr('disabled');
          $("#btnimportsaveslip").html(`Import`);

        },
      });

    });

  });
</script>

<?= $this->endSection(); ?>