<?php

namespace App\Controllers\backend;

use App\Models\backend\LoginModel;
use CodeIgniter\Controller;

use App\Models\backend\KaryawanModel;
use App\Models\backend\MenuModel;
use App\Models\backend\SubmenuModel;
use App\Models\backend\AksesUtamaModel;


class Login extends Controller
{

  protected $loginModel;
  protected $karyawanModel;
  protected $menuModel;
  protected $submenuModel;
  protected $aksesutamaModel;

  public function __construct()
  {
    $this->loginModel = new LoginModel();
    $this->karyawanModel = new KaryawanModel();
    $this->menuModel = new MenuModel();
    $this->submenuModel = new SubmenuModel();
    $this->aksesutamaModel = new AksesUtamaModel();
    // $validation =  \Config\Services::validation();
  }
  public function index()
  {

    $data = [
      'title' => 'Menu Login',
      'validation' => \Config\Services::validation()
    ];
    return view('backend/menulogin', $data);
  }

  public function index2($menu)
  {

    $aksesutama = $this->aksesutamaModel->where('link', $menu)->get()->getRowArray();
    $valuerole = $aksesutama['akses'];

    if ($menu == "kepegawaian") {
      $gambar = "employeemij.png";
      $title = "Login Divisi Kepegawaian";
      // $valuerole = "KEPEGAWAIAN,ADMIN";
    } elseif ($menu == "tu") {
      $gambar = "siswaa.png";
      $title = "Login Divisi Kesiswaan";
      // $valuerole = "TU,ADMIN";
    } elseif ($menu == "keuangan") {
      $gambar = "keuangan_logo.png";
      $title = "Login Divisi Keuangan";
      // $valuerole = "UMUM,ADMIN,KEPEGAWAIAN,TU,PIMPINAN,KEUANGAN,KAMAD,GURU";
    } elseif ($menu == "umum") {
      $gambar = "profilll.png";
      $title = "Login Divisi Umum";
      // $valuerole = "UMUM,ADMIN,KEPEGAWAIAN,TU,PIMPINAN,KEUANGAN,KAMAD,GURU";
    } elseif ($menu == "admin") {
      $gambar = "settingg.png";
      $title = "Login Admin MIJ";
      // $valuerole = "ADMIN,ADMIN";
    }

    $data = [
      'title' => $title,
      'validation' => \Config\Services::validation(),
      'gambar' => $gambar,
      'valuerole' => $valuerole
    ];
    return view('backend/login', $data);
  }

  public function ceklogin()
  {
    if (!$this->validate([
      'username' => [
        'rules'  => 'required',
        'errors' => [
          'required' => 'Username tidak boleh kosong.'
        ]
      ],
      'password'    => [
        'rules'  => 'required',
        'errors' => [
          'required' => 'Password tidak boleh kosong.'
        ]
      ],
    ])) {

      $validation =  \Config\Services::validation();
      $valid = [
        'username' => $validation->getError('username'),
        'password' => $validation->getError('password'),
      ];
      $data = [
        'success' => false,
        'validation' => $valid
      ];
    } else {
      // validasi sukses
      $username = $this->request->getVar('username');
      $password = $this->request->getVar('password');
      $valuerole = $this->request->getVar('valuerole');

      $ceklog = $this->loginModel->where('username', $username)->get()->getRowArray();
      $ceklogcount = $this->loginModel->where('username', $username)->countAllResults();
      // dd($ceklog);

      $pecah = explode(",", $valuerole);

      if ($ceklogcount < 1) {
        $data = [
          'success' => true,
          'responce' => 'not',
          'ceklog' => $ceklog,
          'pesan' => 'Akun tidak ditemukan'
        ];
      } else {
        if (password_verify($password, $ceklog['password'])) {
          // if ($password == $ceklog['password']) {
          if (in_array($ceklog['role_kode'], $pecah)) {
            $data = [
              'success' => true,
              'responce' => 'yes',
              'ceklog' => $ceklog
            ];

            $user = [
              'id' => $ceklog['id'],
              'username' => $ceklog['username'],
              'nama_lengkap' => $ceklog['nama_lengkap'],
              'password' => $ceklog['password'],
              'role_kode' => $ceklog['role_kode'],
              'menunav' => $pecah[0]
            ];

            session()->set($user);
          } else {
            $data = [
              'success' => true,
              'responce' => 'not',
              'ceklog' => $ceklog,
              'pesan' => 'Akun Tidak Sesuai Divisi',
              'pecah' => $pecah
            ];
          }
        } else {
          $data = [
            'success' => true,
            'responce' => 'not',
            'ceklog' => $ceklog,
            'pesan' => 'Password tidak sesuai'
          ];
        }
      }
    }

    return json_encode($data);
  }

  public function logout()
  {
    session()->destroy();
    return redirect()->to(base_url('/'));
  }

  public function block()
  {

    $cekuser = $this->karyawanModel->where('username', session('username'))->get()->getRowArray();
    $menu = $this->menuModel->findAll();
    $submenu = $this->submenuModel->findAll();
    // dd($submenu);

    $data = [
      'title' => 'Block',
      'user' => $cekuser,
      'menu' => $menu,
      'submenu' => $submenu
    ];



    return view('backend/block', $data);
  }
}
